/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology;

import com.mojang.logging.LogUtils;
import cy.jdkdigital.jearchaeology.Config;
import cy.jdkdigital.jearchaeology.jei.BrushRecipeCategory;
import cy.jdkdigital.jearchaeology.jei.SniffRecipeCategory;
import cy.jdkdigital.jearchaeology.network.PacketHandler;
import cy.jdkdigital.jearchaeology.network.packets.Messages;
import cy.jdkdigital.jearchaeology.recipe.BrushingRecipe;
import cy.jdkdigital.jearchaeology.recipe.SniffRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="jearchaeology")
public class JEArchaeology {
    public static final String MODID = "jearchaeology";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"jearchaeology");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"jearchaeology");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"jearchaeology");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"jearchaeology");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256954_, (String)"jearchaeology");
    public static final RegistryObject<RecipeSerializer<SniffRecipe>> SNIFF = RECIPE_SERIALIZERS.register("sniff", () -> new SniffRecipe.Serializer<SniffRecipe>(SniffRecipe::new));
    public static final RegistryObject<RecipeSerializer<BrushingRecipe>> BRUSH = RECIPE_SERIALIZERS.register("brush", () -> new BrushingRecipe.Serializer<BrushingRecipe>(BrushingRecipe::new));
    public static RegistryObject<RecipeType<SniffRecipe>> SNIFF_TYPE = RECIPE_TYPES.register("sniff", () -> new RecipeType<SniffRecipe>(){

        public String toString() {
            return "jearchaeology:sniff";
        }
    });
    public static RegistryObject<RecipeType<BrushingRecipe>> BRUSH_TYPE = RECIPE_TYPES.register("brush", () -> new RecipeType<BrushingRecipe>(){

        public String toString() {
            return "jearchaeology:brush";
        }
    });

    public JEArchaeology() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onCommonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onLootTableLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onDataSync);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        RECIPE_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.init();
    }

    private void onLootTableLoad(LootTableLoadEvent event) {
    }

    private void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketHandler.sendToAllPlayers(new Messages.SnifferDataMessage(SniffRecipeCategory.getAllRecipes(event.getPlayerList().m_7873_().m_129880_(Level.f_46428_))));
            PacketHandler.sendToAllPlayers(new Messages.BrushingDataMessage(BrushRecipeCategory.getAllRecipes(event.getPlayerList().m_7873_().m_129880_(Level.f_46428_))));
        } else {
            PacketHandler.sendDataToPlayer(new Messages.SnifferDataMessage(SniffRecipeCategory.getAllRecipes(event.getPlayerList().m_7873_().m_129880_(Level.f_46428_))), event.getPlayer());
            PacketHandler.sendDataToPlayer(new Messages.BrushingDataMessage(BrushRecipeCategory.getAllRecipes(event.getPlayerList().m_7873_().m_129880_(Level.f_46428_))), event.getPlayer());
        }
    }
}

