/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.grid.handler;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCache;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.preview.ErrorCraftingPreviewElement;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewResponseMessage;
import com.refinedmods.refinedstorage.network.grid.GridCraftingStartResponseMessage;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGridHandler
implements IItemGridHandler {
    private final INetwork network;

    public ItemGridHandler(INetwork network) {
        this.network = network;
    }

    public static void onInventoryScroll(IItemGridHandler gridHandler, ServerPlayer player, int slot, boolean shift, boolean up, @Nullable INetwork network) {
        if (player == null || !(player.f_36096_ instanceof GridContainerMenu)) {
            return;
        }
        if (network != null && (up && !network.getSecurityManager().hasPermission(Permission.INSERT, (Player)player) || !up && !network.getSecurityManager().hasPermission(Permission.EXTRACT, (Player)player))) {
            return;
        }
        int flags = 2;
        ItemStack stackInSlot = player.m_150109_().m_8020_(slot);
        ItemStack stackOnCursor = player.f_36096_.m_142621_();
        if (shift) {
            flags |= 4;
            if (!stackInSlot.m_41619_()) {
                if (up) {
                    player.m_150109_().m_6836_(slot, gridHandler.onInsert(player, stackInSlot, true));
                } else {
                    gridHandler.onExtract(player, stackInSlot, slot, flags);
                }
            }
        } else if (up) {
            if (!stackOnCursor.m_41619_()) {
                gridHandler.onInsert(player, stackOnCursor, true);
            }
        } else if (stackOnCursor.m_41619_()) {
            gridHandler.onExtract(player, stackInSlot, -1, flags);
        } else {
            gridHandler.onExtract(player, stackOnCursor, -1, flags);
        }
    }

    public static void onGridScroll(IItemGridHandler gridHandler, ServerPlayer player, @Nullable UUID id, boolean shift, boolean up, @Nullable INetwork network) {
        if (player == null || !(player.f_36096_ instanceof GridContainerMenu)) {
            return;
        }
        if (network != null && (up && !network.getSecurityManager().hasPermission(Permission.INSERT, (Player)player) || !up && !network.getSecurityManager().hasPermission(Permission.EXTRACT, (Player)player))) {
            return;
        }
        IGrid grid = ((GridContainerMenu)player.f_36096_).getGrid();
        int flags = 2;
        if (shift && id != null) {
            flags |= 4;
            if (up) {
                IStorageCache cache = grid.getStorageCache();
                if (cache == null || cache.getList().get(id) == null) {
                    return;
                }
                for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                    if (!API.instance().getComparer().isEqual(player.m_150109_().m_8020_(i), (ItemStack)cache.getList().get(id), 1)) continue;
                    gridHandler.onInsert(player, player.m_150109_().m_8020_(i), true);
                    break;
                }
            } else {
                gridHandler.onExtract(player, id, -1, flags);
            }
        } else if (!up && id != null) {
            gridHandler.onExtract(player, id, -1, flags);
        } else if (up && !player.f_36096_.m_142621_().m_41619_()) {
            gridHandler.onInsert(player, player.f_36096_.m_142621_(), true);
        }
    }

    @Override
    public void onExtract(ServerPlayer player, ItemStack stack, int preferredSlot, int flags) {
        StackListEntry<ItemStack> stackEntry = this.network.getItemStorageCache().getList().getEntry(stack, 1);
        if (stackEntry != null) {
            this.onExtract(player, stackEntry.getId(), preferredSlot, flags);
        }
    }

    @Override
    public void onExtract(ServerPlayer player, UUID id, int preferredSlot, int flags) {
        ItemStack item = this.network.getItemStorageCache().getList().get(id);
        if (item == null || !this.network.getSecurityManager().hasPermission(Permission.EXTRACT, (Player)player) || !this.network.canRun()) {
            return;
        }
        int itemSize = item.m_41613_();
        int maxItemSize = item.m_41720_().getMaxStackSize(item.m_41777_());
        boolean single = (flags & 2) == 2;
        ItemStack held = player.f_36096_.m_142621_();
        if (single ? !held.m_41619_() && (!API.instance().getComparer().isEqualNoQuantity(item, held) || held.m_41613_() + 1 > held.m_41741_()) : !player.f_36096_.m_142621_().m_41619_()) {
            return;
        }
        int size = 64;
        if ((flags & 1) == 1 && itemSize > 1) {
            size = itemSize / 2;
            if (size > maxItemSize / 2 && maxItemSize != 1) {
                size = maxItemSize / 2;
            }
        } else if (single) {
            size = 1;
        } else if ((flags & 4) == 4) {
            // empty if block
        }
        size = Math.min(size, maxItemSize);
        this.network.getItemStorageTracker().changed((Player)player, item.m_41777_());
        ItemStack took = this.network.extractItem(item, size, Action.SIMULATE);
        if (!took.m_41619_()) {
            if ((flags & 4) == 4) {
                Optional playerInventory = player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).resolve();
                if (playerInventory.isPresent()) {
                    ItemStack remainder;
                    if (preferredSlot != -1 && (remainder = ((IItemHandler)playerInventory.get()).insertItem(preferredSlot, took, true)).m_41613_() != took.m_41613_()) {
                        ItemStack inserted = this.network.extractItem(item, size - remainder.m_41613_(), Action.PERFORM);
                        ((IItemHandler)playerInventory.get()).insertItem(preferredSlot, inserted, false);
                        took.m_41764_(remainder.m_41613_());
                    }
                    if (!took.m_41619_() && ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)playerInventory.get()), (ItemStack)took, (boolean)true).m_41619_()) {
                        took = this.network.extractItem(item, size, Action.PERFORM);
                        ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)playerInventory.get()), (ItemStack)took, (boolean)false);
                    }
                }
            } else {
                took = this.network.extractItem(item, size, Action.PERFORM);
                if (!took.m_41619_()) {
                    if (single && !held.m_41619_()) {
                        held.m_41769_(1);
                    } else {
                        player.f_36096_.m_142503_(took);
                    }
                }
            }
            this.network.getNetworkItemManager().drainEnergy((Player)player, RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage());
        }
    }

    @Override
    @Nonnull
    public ItemStack onInsert(ServerPlayer player, ItemStack stack, boolean single) {
        ItemStack remainder;
        if (!this.network.getSecurityManager().hasPermission(Permission.INSERT, (Player)player) || !this.network.canRun()) {
            return stack;
        }
        this.network.getItemStorageTracker().changed((Player)player, stack.m_41777_());
        if (single) {
            if (this.network.insertItem(stack, 1, Action.SIMULATE).m_41619_()) {
                this.network.insertItem(stack, 1, Action.PERFORM);
                stack.m_41774_(1);
            }
            remainder = stack;
        } else {
            remainder = this.network.insertItem(stack, stack.m_41613_(), Action.PERFORM);
        }
        this.network.getNetworkItemManager().drainEnergy((Player)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
        return remainder;
    }

    @Override
    public void onInsertHeldItem(ServerPlayer player, boolean single) {
        if (player.f_36096_.m_142621_().m_41619_() || !this.network.getSecurityManager().hasPermission(Permission.INSERT, (Player)player) || !this.network.canRun()) {
            return;
        }
        ItemStack stack = player.f_36096_.m_142621_();
        int size = single ? 1 : stack.m_41613_();
        this.network.getItemStorageTracker().changed((Player)player, stack.m_41777_());
        if (single) {
            if (this.network.insertItem(stack, size, Action.SIMULATE).m_41619_()) {
                this.network.insertItem(stack, size, Action.PERFORM);
                stack.m_41774_(size);
            }
        } else {
            player.f_36096_.m_142503_(this.network.insertItem(stack, size, Action.PERFORM));
        }
        this.network.getNetworkItemManager().drainEnergy((Player)player, RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage());
    }

    @Override
    public void onCraftingPreviewRequested(ServerPlayer player, UUID id, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null) {
            ICalculationResult result = this.network.getCraftingManager().create(stack, quantity);
            if (!result.isOk() && result.getType() != CalculationResultType.MISSING) {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(Collections.singletonList(new ErrorCraftingPreviewElement(result.getType(), result.getRecursedPattern() == null ? ItemStack.f_41583_ : result.getRecursedPattern().getStack())), id, quantity, false));
            } else if (result.isOk() && noPreview) {
                this.network.getCraftingManager().start(result.getTask());
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingStartResponseMessage());
            } else {
                RS.NETWORK_HANDLER.sendTo(player, new GridCraftingPreviewResponseMessage(result.getPreviewElements(), id, quantity, false));
            }
        }
    }

    @Override
    public void onCraftingRequested(ServerPlayer player, UUID id, int quantity) {
        ICalculationResult result;
        if (quantity <= 0 || !this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)player)) {
            return;
        }
        ItemStack stack = this.network.getItemStorageCache().getCraftablesList().get(id);
        if (stack != null && (result = this.network.getCraftingManager().create(stack, quantity)).isOk()) {
            this.network.getCraftingManager().start(result.getTask());
        }
    }

    @Override
    public void onCraftingCancelRequested(ServerPlayer player, @Nullable UUID id) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (Player)player)) {
            return;
        }
        this.network.getCraftingManager().cancel(id);
        this.network.getNetworkItemManager().drainEnergy((Player)player, id == null ? RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelAllUsage() : RS.SERVER_CONFIG.getWirelessCraftingMonitor().getCancelUsage());
    }

    @Override
    public void onInventoryScroll(ServerPlayer player, int slot, boolean shift, boolean up) {
        ItemGridHandler.onInventoryScroll(this, player, slot, shift, up, this.network);
    }

    @Override
    public void onGridScroll(ServerPlayer player, @Nullable UUID id, boolean shift, boolean up) {
        ItemGridHandler.onGridScroll(this, player, id, shift, up, this.network);
    }
}

