/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.armor;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.exosuit.IExosuitSensor;
import vazkii.psi.api.exosuit.ISensorHoldable;
import vazkii.psi.common.item.armor.ItemPsimetalArmor;

public class ItemPsimetalExosuitHelmet
extends ItemPsimetalArmor
implements ISensorHoldable,
DyeableLeatherItem {
    private static final String TAG_SENSOR = "sensor";

    public ItemPsimetalExosuitHelmet(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    public String getEvent(ItemStack stack) {
        ItemStack sensor = this.getAttachedSensor(stack);
        if (!sensor.m_41619_() && sensor.m_41720_() instanceof IExosuitSensor) {
            return ((IExosuitSensor)sensor.m_41720_()).getEventType(sensor);
        }
        return super.getEvent(stack);
    }

    @Override
    public int getCastCooldown(ItemStack stack) {
        return 40;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_41121_(@Nonnull ItemStack stack) {
        ItemStack sensor = this.getAttachedSensor(stack);
        if (!sensor.m_41619_() && sensor.m_41720_() instanceof IExosuitSensor) {
            return ((IExosuitSensor)sensor.m_41720_()).getColor(sensor);
        }
        return super.getColor(stack);
    }

    @Override
    public ItemStack getAttachedSensor(ItemStack stack) {
        CompoundTag cmp = stack.m_41784_().m_128469_(TAG_SENSOR);
        return ItemStack.m_41712_((CompoundTag)cmp);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        boolean overlay = type != null && type.equals("overlay");
        return overlay ? "psi:textures/model/psimetal_exosuit.png" : "psi:textures/model/psimetal_exosuit_sensor.png";
    }

    @Override
    public void attachSensor(ItemStack stack, ItemStack sensor) {
        CompoundTag cmp = new CompoundTag();
        if (!sensor.m_41619_()) {
            sensor.m_41739_(cmp);
        }
        stack.m_41784_().m_128365_(TAG_SENSOR, (Tag)cmp);
    }
}

