/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ObjectHolder;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.entity.EntitySpellProjectile;

public class EntitySpellGrenade
extends EntitySpellProjectile {
    @ObjectHolder(registryName="minecraft:entity_type", value="psi:spell_grenade")
    public static EntityType<EntitySpellGrenade> TYPE;
    boolean sound = false;

    public EntitySpellGrenade(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    protected EntitySpellGrenade(EntityType<? extends ThrowableProjectile> type, Level worldIn, LivingEntity throwerIn) {
        super(type, worldIn, throwerIn);
        double speed = 0.65;
        this.m_20256_(this.m_20184_().m_82542_(speed, speed, speed));
    }

    public EntitySpellGrenade(Level world, LivingEntity thrower) {
        this(TYPE, world, thrower);
    }

    @Override
    protected float m_7139_() {
        return 0.05f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 60 && this.m_6084_() && this.explodes()) {
            this.doExplosion();
        }
    }

    public void doExplosion() {
        if (this.getAttackTarget() != null) {
            this.cast(context -> {
                if (context != null) {
                    context.attackedEntity = this.getAttackTarget();
                }
            });
        } else {
            this.cast();
        }
        this.m_5496_(SoundEvents.f_11913_, 0.5f, 1.0f);
        double m = 0.1;
        for (int j = 0; j < 40; ++j) {
            double d0 = this.m_20193_().f_46441_.m_188583_() * m;
            double d1 = this.m_20193_().f_46441_.m_188583_() * m;
            double d2 = this.m_20193_().f_46441_.m_188583_() * m;
            double x = this.m_20185_() + 0.75 * (double)this.m_20193_().f_46441_.m_188501_() - 0.375;
            double y = this.m_20186_() + 0.5 * (double)this.m_20193_().f_46441_.m_188501_();
            double z = this.m_20189_() + 0.75 * (double)this.m_20193_().f_46441_.m_188501_() - 0.375;
            this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, x, y, z, d0, d1, d2);
        }
    }

    public boolean explodes() {
        return true;
    }

    @Override
    protected void m_6532_(@Nonnull HitResult ray) {
        if (ray instanceof EntityHitResult && ((EntityHitResult)ray).m_82443_() instanceof LivingEntity) {
            this.f_19804_.m_135381_(ATTACKTARGET_UUID, Optional.of(((EntityHitResult)ray).m_82443_().m_20148_()));
        }
        if (!this.m_20193_().f_46443_ && !this.sound && this.explodes()) {
            this.m_5496_(SoundEvents.f_11837_, 2.0f, 1.0f);
            this.sound = true;
        }
        if (ray.m_6662_() == HitResult.Type.BLOCK) {
            Direction face = ((BlockHitResult)ray).m_82434_();
            Vector3 position = Vector3.fromVec3d(ray.m_82450_());
            if (face != Direction.UP) {
                position.add(Vector3.fromDirection(face).multiply(0.1));
            }
            this.m_6021_(position.x, position.y, position.z);
            this.m_20256_(Vec3.f_82478_);
        } else if (ray.m_6662_() == HitResult.Type.ENTITY) {
            this.m_6021_(ray.m_82450_().f_82479_, ray.m_82450_().f_82480_, ray.m_82450_().f_82481_);
            this.m_20256_(Vec3.f_82478_);
        }
    }
}

