/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.common.item.ItemCAD;

public class ColorizerChangeRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<ColorizerChangeRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ColorizerChangeRecipe::new);

    public ColorizerChangeRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundColorizer = false;
        boolean foundCAD = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICAD) {
                if (foundCAD) {
                    return false;
                }
                foundCAD = true;
                continue;
            }
            if (stack.m_41720_() instanceof ICADColorizer) {
                if (foundColorizer) {
                    return false;
                }
                foundColorizer = true;
                continue;
            }
            return false;
        }
        return foundColorizer && foundCAD;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        ItemStack colorizer = ItemStack.f_41583_;
        ItemStack cad = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ICADColorizer) {
                colorizer = stack;
                continue;
            }
            cad = stack;
        }
        if (cad.m_41619_() || colorizer.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copy = cad.m_41777_();
        ItemCAD.setComponent(copy, colorizer);
        return copy;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int dyeIndex = -1;
        ItemStack cad = ItemStack.f_41583_;
        for (int i = 0; i < ret.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41720_() instanceof ICAD) {
                cad = stack;
                continue;
            }
            if (!stack.m_41619_() && stack.m_41720_() instanceof ICADColorizer) {
                dyeIndex = i;
            }
            ret.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)stack));
        }
        if (!cad.m_41619_() && dyeIndex != -1) {
            ICAD icad = (ICAD)cad.m_41720_();
            ret.set(dyeIndex, (Object)icad.getComponentInSlot(cad, EnumCADComponent.DYE));
        }
        return ret;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }
}

