/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.psi.client.jei.crafting.BulletToDriveExtension;
import vazkii.psi.client.jei.crafting.DriveDuplicateExtension;
import vazkii.psi.client.jei.tricks.TrickCraftingCategory;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.crafting.recipe.DriveDuplicateRecipe;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.ModItems;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("psi", "main");
    public static IJeiHelpers helpers;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        helpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new TrickCraftingCategory(helpers.getGuiHelper())});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(BulletToDriveRecipe.class, BulletToDriveExtension::new);
        registration.getCraftingCategory().addCategoryExtension(DriveDuplicateRecipe.class, DriveDuplicateExtension::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(TrickCraftingCategory.TYPE, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(ModCraftingRecipes.TRICK_RECIPE_TYPE));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        List<ItemStack> stacks = ItemCAD.getCreativeTabItems();
        for (ItemStack stack : stacks) {
            registration.addRecipeCatalyst(stack, new RecipeType[]{TrickCraftingCategory.TYPE});
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModItems.cad});
    }
}

