/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.mixin;

import com.affehund.voidtotem.core.ILivingEntityMixin;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.mixin.ServerGamePacketListenerImplAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements ILivingEntityMixin {
    private boolean isFallDamageImmune;
    private long lastSaveBlockPos;
    private DimensionType lastSaveBlockDim;

    @Inject(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (ModUtils.canProtectFromVoid(livingEntity, source)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (((ILivingEntityMixin)livingEntity).isFallDamageImmune()) {
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.f_8906_).setAboveGroundTickCount(0);
            }
            ((ILivingEntityMixin)livingEntity).setFallDamageImmune(false);
            cir.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        ModUtils.setLastSaveBlockPos(livingEntity);
        ModUtils.resetFallDamageImmunity(livingEntity);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt(@NotNull CompoundTag tag, CallbackInfo ci) {
        this.isFallDamageImmune = tag.m_128471_("Void TotemIsFallDamageImmune");
        this.lastSaveBlockPos = tag.m_128454_("Void TotemLastSaveBlockPos");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt(@NotNull CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("Void TotemIsFallDamageImmune", this.isFallDamageImmune);
        tag.m_128356_("Void TotemLastSaveBlockPos", this.lastSaveBlockPos);
    }

    @Override
    public boolean isFallDamageImmune() {
        return this.isFallDamageImmune;
    }

    @Override
    public void setFallDamageImmune(boolean isImmune) {
        this.isFallDamageImmune = isImmune;
    }

    @Override
    public long getLastSaveBlockPosAsLong() {
        return this.lastSaveBlockPos;
    }

    @Override
    public void setLastSaveBlockPosAsLong(long pos) {
        this.lastSaveBlockPos = pos;
    }

    @Override
    public DimensionType getLastSaveBlockDim() {
        return this.lastSaveBlockDim;
    }

    @Override
    public void setLastSaveBlockDim(DimensionType dimensionType) {
        this.lastSaveBlockDim = dimensionType;
    }
}

