/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UpgradedGateBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<DoorHingeSide> HINGE = EnumProperty.m_61587_((String)"hinge", DoorHingeSide.class);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty DOUBLE = BooleanProperty.m_61465_((String)"double");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> COLLISION_SHAPES;

    public UpgradedGateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_(), false);
        this.COLLISION_SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_(), true);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, boolean collision) {
        VoxelShape[] RIGHT_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.5, (double)1.0, (double)7.0, (double)14.5, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_DOUBLE_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)0.0, (double)1.0, (double)7.0, (double)14.0, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)1.0, (double)-5.0, (double)15.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] RIGHT_DOUBLE_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)13.0, (double)1.0, (double)-6.0, (double)15.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] RIGHT_HINGE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)14.0, (double)3.0, (double)7.0, (double)15.0, (double)6.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_HINGE_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)14.0, (double)12.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] RIGHT_POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)15.0, (double)0.0, (double)6.0, (double)18.0, (double)17.0, (double)10.0), Direction.SOUTH));
        VoxelShape[] LEFT_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.5, (double)1.0, (double)7.0, (double)14.5, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_DOUBLE_GATE_CLOSED = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)2.0, (double)1.0, (double)7.0, (double)16.0, (double)17.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)1.0, (double)-5.0, (double)3.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] LEFT_DOUBLE_GATE_OPEN = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)1.0, (double)-6.0, (double)3.0, (double)17.0, (double)8.0), Direction.SOUTH));
        VoxelShape[] LEFT_HINGE_BOTTOM = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)3.0, (double)7.0, (double)2.0, (double)6.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_HINGE_TOP = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.0, (double)12.0, (double)7.0, (double)2.0, (double)15.0, (double)9.0), Direction.SOUTH));
        VoxelShape[] LEFT_POST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)-2.0, (double)0.0, (double)6.0, (double)1.0, (double)17.0, (double)10.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            DoorHingeSide hingeSide = (DoorHingeSide)state.m_61143_(HINGE);
            boolean open = (Boolean)state.m_61143_((Property)OPEN);
            boolean double_ = (Boolean)state.m_61143_((Property)DOUBLE);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            switch (hingeSide) {
                case LEFT: {
                    VoxelShape doubleGate;
                    VoxelShape post = LEFT_POST[direction.m_122416_()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    shapes.add(LEFT_HINGE_BOTTOM[direction.m_122416_()]);
                    shapes.add(LEFT_HINGE_TOP[direction.m_122416_()]);
                    if (open) {
                        VoxelShape voxelShape = doubleGate = double_ ? LEFT_DOUBLE_GATE_OPEN[direction.m_122416_()] : LEFT_GATE_OPEN[direction.m_122416_()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    } else {
                        VoxelShape voxelShape = doubleGate = double_ ? LEFT_DOUBLE_GATE_CLOSED[direction.m_122416_()] : LEFT_GATE_CLOSED[direction.m_122416_()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    }
                    if (double_) break;
                    post = RIGHT_POST[direction.m_122416_()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    break;
                }
                case RIGHT: {
                    VoxelShape doubleGate;
                    VoxelShape post = RIGHT_POST[direction.m_122416_()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                    shapes.add(RIGHT_HINGE_BOTTOM[direction.m_122416_()]);
                    shapes.add(RIGHT_HINGE_TOP[direction.m_122416_()]);
                    if (open) {
                        VoxelShape voxelShape = doubleGate = double_ ? RIGHT_DOUBLE_GATE_OPEN[direction.m_122416_()] : RIGHT_GATE_OPEN[direction.m_122416_()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    } else {
                        VoxelShape voxelShape = doubleGate = double_ ? RIGHT_DOUBLE_GATE_CLOSED[direction.m_122416_()] : RIGHT_GATE_CLOSED[direction.m_122416_()];
                        if (collision) {
                            doubleGate = VoxelShapeHelper.setMaxHeight(doubleGate, 1.5);
                            doubleGate = VoxelShapeHelper.limitHorizontal(doubleGate);
                        }
                        shapes.add(doubleGate);
                    }
                    if (double_) break;
                    post = LEFT_POST[direction.m_122416_()];
                    if (collision) {
                        post = VoxelShapeHelper.setMaxHeight(post, 1.5);
                        post = VoxelShapeHelper.limitHorizontal(post);
                    }
                    shapes.add(post);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.COLLISION_SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        Direction hitFace = result.m_82434_();
        Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
        boolean open = (Boolean)state.m_61143_((Property)OPEN);
        if (hitFace.m_122434_() != direction.m_122434_() && (!open || hitFace.m_122434_().m_122478_())) {
            return InteractionResult.PASS;
        }
        DoorHingeSide hingeSide = (DoorHingeSide)state.m_61143_(HINGE);
        this.openGate(state, (LevelAccessor)level, pos, direction, hitFace, !open);
        this.openDoubleGate((LevelAccessor)level, pos, direction, hitFace, hingeSide, !open);
        this.openAdjacentGate((LevelAccessor)level, pos, direction, Direction.UP, hitFace, hingeSide, !open, 5);
        this.openAdjacentGate((LevelAccessor)level, pos, direction, Direction.DOWN, hitFace, hingeSide, !open, 5);
        level.m_5898_(playerEntity, !open ? 1008 : 1014, pos, 0);
        return InteractionResult.SUCCESS;
    }

    private void openGate(BlockState state, LevelAccessor level, BlockPos pos, Direction direction, Direction hitFace, boolean open) {
        if (open) {
            if (hitFace.m_122424_() == direction) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            } else if (hitFace == direction) {
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_(HINGE, (Comparable)this.getOppositeHinge((DoorHingeSide)state.m_61143_(HINGE)))).m_61124_((Property)DIRECTION, (Comparable)hitFace.m_122424_()), 3);
            }
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void openAdjacentGate(LevelAccessor level, BlockPos pos, Direction direction, Direction offset, Direction hitFace, DoorHingeSide hingeSide, boolean open, int limit) {
        if (limit <= 0) {
            return;
        }
        BlockPos offsetPos = pos.m_121945_(offset);
        BlockState state = level.m_8055_(offsetPos);
        if (state.m_60734_() == this) {
            if (state.m_61143_((Property)DIRECTION) != direction || state.m_61143_(HINGE) != hingeSide || (Boolean)state.m_61143_((Property)OPEN) == open) {
                return;
            }
            this.openGate(state, level, offsetPos, direction, hitFace, open);
            this.openDoubleGate(level, offsetPos, direction, hitFace, hingeSide, open);
            this.openAdjacentGate(level, offsetPos, direction, offset, hitFace, hingeSide, open, limit - 1);
        }
    }

    private void openDoubleGate(LevelAccessor level, BlockPos pos, Direction direction, Direction hitFace, DoorHingeSide hingeSide, boolean open) {
        BlockPos adjacentPos = pos.m_121945_(hingeSide == DoorHingeSide.LEFT ? direction.m_122427_() : direction.m_122428_());
        BlockState adjacentState = level.m_8055_(adjacentPos);
        if (adjacentState.m_60734_() == this && ((Direction)adjacentState.m_61143_((Property)DIRECTION)).m_122434_() == direction.m_122434_()) {
            if (adjacentState.m_61143_(HINGE) != hingeSide) {
                this.openGate(adjacentState, level, adjacentPos, direction, hitFace, open);
            } else {
                this.openGate((BlockState)((BlockState)adjacentState.m_61124_((Property)DIRECTION, (Comparable)((Direction)adjacentState.m_61143_((Property)DIRECTION)).m_122424_())).m_61124_(HINGE, (Comparable)this.getOppositeHinge((DoorHingeSide)adjacentState.m_61143_(HINGE))), level, adjacentPos, direction, hitFace, open);
            }
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_(HINGE, (Comparable)this.getHingeSide(context));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        Direction facing = (Direction)state.m_61143_((Property)DIRECTION);
        Direction offset = state.m_61143_(HINGE) == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_();
        BlockState adjacentBlock = level.m_8055_(pos.m_121945_(offset));
        return (BlockState)state.m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(adjacentBlock.m_60734_() == this));
    }

    private DoorHingeSide getHingeSide(BlockPlaceContext context) {
        Direction playerFacing = context.m_8125_();
        int offsetX = playerFacing.m_122429_();
        int offsetZ = playerFacing.m_122431_();
        BlockPos pos = context.m_8083_();
        Vec3 hitVec = context.m_43720_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        boolean side = offsetX < 0 && hitVec.f_82481_ < 0.5 || offsetX > 0 && hitVec.f_82481_ > 0.5 || offsetZ < 0 && hitVec.f_82479_ > 0.5 || offsetZ > 0 && hitVec.f_82479_ < 0.5;
        return side ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    private DoorHingeSide getOppositeHinge(DoorHingeSide hingeSide) {
        return hingeSide == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HINGE});
        builder.m_61104_(new Property[]{OPEN});
        builder.m_61104_(new Property[]{DOUBLE});
        builder.m_61104_(new Property[]{POWERED});
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Boolean)state.m_61143_((Property)OPEN) == false ? BlockPathTypes.FENCE : BlockPathTypes.OPEN;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.m_5776_()) {
            boolean powered = level.m_276867_(pos);
            if ((Boolean)state.m_61143_((Property)POWERED) != powered) {
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered)), 2);
                if ((Boolean)state.m_61143_((Property)OPEN) != powered) {
                    level.m_5898_(null, powered ? 1008 : 1014, pos, 0);
                }
            }
        }
    }
}

