/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.IInfusionRecipe;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class InfusionCategory
implements IRecipeCategory<IInfusionRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mysticalagriculture", "textures/jei/infusion.png");
    public static final RecipeType<IInfusionRecipe> RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"infusion", IInfusionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public InfusionCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 81);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INFUSION_ALTAR.get()));
    }

    public RecipeType<IInfusionRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.mysticalagriculture.infusion").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IInfusionRecipe recipe, IFocusGroup focuses) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_(level.m_9598_());
        builder.addSlot(RecipeIngredientRole.INPUT, 33, 33).addIngredients((Ingredient)inputs.get(0));
        int pedestals = (int)inputs.stream().filter(i -> !i.m_43947_()).count() - 1;
        switch (pedestals) {
            case 1: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(1));
                break;
            }
            case 2: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH, (Ingredient)inputs.get(2));
                break;
            }
            case 3: {
                InfusionCategory.addSlot(builder, SlotPosition.WEST, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.EAST, (Ingredient)inputs.get(3));
                break;
            }
            case 4: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.EAST, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH, (Ingredient)inputs.get(3));
                InfusionCategory.addSlot(builder, SlotPosition.WEST, (Ingredient)inputs.get(4));
                break;
            }
            case 5: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_WEST, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_EAST, (Ingredient)inputs.get(3));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_EAST, (Ingredient)inputs.get(4));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_WEST, (Ingredient)inputs.get(5));
                break;
            }
            case 6: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_WEST, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_EAST, (Ingredient)inputs.get(3));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_EAST, (Ingredient)inputs.get(4));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH, (Ingredient)inputs.get(5));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_WEST, (Ingredient)inputs.get(6));
                break;
            }
            case 7: {
                InfusionCategory.addSlot(builder, SlotPosition.WEST, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_WEST, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(3));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_EAST, (Ingredient)inputs.get(4));
                InfusionCategory.addSlot(builder, SlotPosition.EAST, (Ingredient)inputs.get(5));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_EAST, (Ingredient)inputs.get(6));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_WEST, (Ingredient)inputs.get(7));
                break;
            }
            case 8: {
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_WEST, (Ingredient)inputs.get(1));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH, (Ingredient)inputs.get(2));
                InfusionCategory.addSlot(builder, SlotPosition.NORTH_EAST, (Ingredient)inputs.get(3));
                InfusionCategory.addSlot(builder, SlotPosition.EAST, (Ingredient)inputs.get(4));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_EAST, (Ingredient)inputs.get(5));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH, (Ingredient)inputs.get(6));
                InfusionCategory.addSlot(builder, SlotPosition.SOUTH_WEST, (Ingredient)inputs.get(7));
                InfusionCategory.addSlot(builder, SlotPosition.WEST, (Ingredient)inputs.get(8));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 123, 33).addItemStack(output);
    }

    private static void addSlot(IRecipeLayoutBuilder builder, SlotPosition position, Ingredient ingredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, position.x, position.y).addIngredients(ingredient);
    }

    private static enum SlotPosition {
        NORTH_WEST(7, 7),
        NORTH(33, 1),
        NORTH_EAST(59, 7),
        EAST(65, 33),
        SOUTH_EAST(59, 59),
        SOUTH(33, 64),
        SOUTH_WEST(7, 59),
        WEST(1, 33);

        final int x;
        final int y;

        private SlotPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

