/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.registry;

import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.common.blocks.ChemicalBlock;
import com.smashingmods.chemlib.common.items.ChemicalItem;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.registry.FluidRegistry;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Comparator;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="chemlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TabsRegistry {
    public static final DeferredRegister<CreativeModeTab> REGISTRY_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"chemlib");
    public static RegistryObject<CreativeModeTab> ELEMENT_TAB;
    public static RegistryObject<CreativeModeTab> COMPOUND_TAB;
    public static RegistryObject<CreativeModeTab> METALS_TAB;
    public static RegistryObject<CreativeModeTab> MISC_TAB;

    public static void register(IEventBus pEventBus) {
        ELEMENT_TAB = REGISTRY_TABS.register("element_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257737_(() -> ItemRegistry.getElementByName("hydrogen").map(ItemStack::new).orElseGet(() -> new ItemStack((ItemLike)Items.f_41852_))).m_257941_((Component)Component.m_237115_((String)"itemGroup.chemlib.elements")).m_257501_((pParameters, pOutput) -> ItemRegistry.getElements().forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0))).m_257652_());
        COMPOUND_TAB = REGISTRY_TABS.register("compound_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{ELEMENT_TAB.getKey()}).m_257737_(() -> ItemRegistry.getCompoundByName("cobalt_aluminate").map(ItemStack::new).orElseGet(() -> new ItemStack((ItemLike)Items.f_41852_))).m_257941_((Component)Component.m_237115_((String)"itemGroup.chemlib.compounds")).m_257501_((pParameters, pOutput) -> {
            ItemRegistry.REGISTRY_COMPOUNDS.getEntries().stream().map(RegistryObject::get).map(item -> (CompoundItem)item).sorted(Comparator.comparing(CompoundItem::getChemicalName)).toList().forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0));
            ItemRegistry.getChemicalItemsByTypeAsStream(ChemicalItemType.COMPOUND).sorted(Comparator.comparing(ChemicalItem::getChemicalName)).toList().forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0));
        }).m_257652_());
        METALS_TAB = REGISTRY_TABS.register("metals_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{COMPOUND_TAB.getKey()}).m_257737_(() -> ItemRegistry.getChemicalItemByNameAndType("barium", ChemicalItemType.INGOT).map(ItemStack::new).orElseGet(() -> new ItemStack((ItemLike)Items.f_41852_))).m_257941_((Component)Component.m_237115_((String)"itemGroup.chemlib.metals")).m_257501_((pParameters, pOutput) -> {
            ItemRegistry.getChemicalItemsByType(ChemicalItemType.INGOT).stream().map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
            ItemRegistry.getChemicalBlockItems().stream().filter(item -> ((ChemicalBlock)item.m_40614_()).getBlockType().m_7912_().equals("metal")).map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
            ItemRegistry.getChemicalItemsByType(ChemicalItemType.NUGGET).stream().map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
            ItemRegistry.getChemicalItemsByType(ChemicalItemType.DUST).stream().map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
            ItemRegistry.getChemicalItemsByType(ChemicalItemType.PLATE).stream().filter(chemicalItem -> !chemicalItem.m_5524_().equals("item.chemlib.polyvinyl_chloride_plate")).map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
        }).m_257652_());
        MISC_TAB = REGISTRY_TABS.register("misc_tab", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{METALS_TAB.getKey()}).m_257737_(() -> ItemRegistry.getChemicalBlockItemByName("radon_lamp_block").map(ItemStack::new).orElseGet(() -> new ItemStack((ItemLike)Items.f_41852_))).m_257941_((Component)Component.m_237115_((String)"itemGroup.chemlib.misc")).m_257501_((pParameters, pOutput) -> {
            ItemRegistry.REGISTRY_BLOCK_ITEMS.getEntries().stream().map(RegistryObject::get).filter(item -> item.m_5524_().contains("lamp_block")).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0));
            ItemRegistry.REGISTRY_MISC_ITEMS.getEntries().stream().map(RegistryObject::get).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0));
            ItemRegistry.getChemicalItemByNameAndType("polyvinyl_chloride", ChemicalItemType.PLATE).ifPresent(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246326_(arg_0));
            FluidRegistry.getAllSortedBuckets().stream().map(ItemStack::new).forEach(arg_0 -> ((CreativeModeTab.Output)pOutput).m_246342_(arg_0));
        }).m_257652_());
        REGISTRY_TABS.register(pEventBus);
    }
}

