/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jomcraft.defaultsettings.ChatColors;
import net.jomcraft.defaultsettings.Core;
import net.jomcraft.defaultsettings.KeyPlaceholder;
import net.jomcraft.defaultsettings.MutableBoolean;
import net.jomcraft.defaultsettings.ThreadRunnable;
import org.apache.logging.log4j.Level;

public class CoreUtil {
    private static ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static void restoreKeys(boolean update, boolean initial) throws IOException, NullPointerException {
        Core.getInstance().clearKeyBinds();
        File keysFile = new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/keys.txt");
        if (keysFile.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    String[] parts = line.split(":");
                    if (parts[parts.length - 1].contains("key.") || CoreUtil.numberParsable(parts[parts.length - 1])) {
                        Object keyName = "";
                        for (int i = 0; i < parts.length - 1; ++i) {
                            keyName = (String)keyName + (((String)keyName).isEmpty() ? "" : ":") + parts[i];
                        }
                        String bind = parts[parts.length - 1];
                        Core.getInstance().putKeybind((String)keyName, bind, null);
                        continue;
                    }
                    String modifier = parts[parts.length - 1];
                    Object keyName = "";
                    for (int i = 0; i < parts.length - 2; ++i) {
                        keyName = (String)keyName + (((String)keyName).isEmpty() ? "" : ":") + parts[i];
                    }
                    String bind = parts[parts.length - 2];
                    Core.getInstance().putKeybind((String)keyName, bind, modifier);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            if (update) {
                ArrayList<String> presentKeys = new ArrayList<String>();
                File localKeysFile = new File(Core.getInstance().getMCDataDir(), "options.txt");
                if (localKeysFile.exists()) {
                    BufferedReader localReader = null;
                    try {
                        String line;
                        localReader = new BufferedReader(new FileReader(localKeysFile));
                        while ((line = localReader.readLine()) != null) {
                            int i;
                            Object keyName;
                            if (line.isEmpty() || !line.startsWith("key_key.")) continue;
                            String[] parts = line.split(":");
                            if (parts[parts.length - 1].contains("key.") || CoreUtil.numberParsable(parts[parts.length - 1])) {
                                keyName = "";
                                for (i = 0; i < parts.length - 1; ++i) {
                                    keyName = (String)keyName + (((String)keyName).isEmpty() ? "" : ":") + parts[i];
                                }
                                presentKeys.add(((String)keyName).substring(4));
                                continue;
                            }
                            keyName = "";
                            for (i = 0; i < parts.length - 2; ++i) {
                                keyName = (String)keyName + (((String)keyName).isEmpty() ? "" : ":") + parts[i];
                            }
                            presentKeys.add(((String)keyName).substring(4));
                        }
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (NullPointerException e) {
                        throw e;
                    }
                    finally {
                        try {
                            localReader.close();
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (NullPointerException e) {
                            throw e;
                        }
                    }
                }
                for (KeyPlaceholder keyBinding : Core.getInstance().getKeyMappings()) {
                    if (!Core.getInstance().keybindExists(keyBinding.name)) continue;
                    boolean init = false;
                    if (initial || !presentKeys.contains(keyBinding.name)) {
                        init = true;
                    }
                    Core.getInstance().setKeybind(keyBinding, init);
                }
                Core.getInstance().resetMappings();
            }
        }
    }

    public static boolean numberParsable(String text) {
        try {
            if (!text.startsWith("scancode.")) {
                Integer.parseInt(text);
            }
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static InputStream getKeysStream(boolean noModifier) throws IOException, NullPointerException {
        FileInputStream stream;
        File file = new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/keys.txt_temp");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(file));
            for (KeyPlaceholder keyBinding : Core.getInstance().getKeyMappings()) {
                writer.print(keyBinding.name + ":" + keyBinding.key + (String)(noModifier ? "" : ":" + keyBinding.modifier) + "\n");
            }
            stream = new FileInputStream(file);
        }
        return stream;
    }

    public static void saveKeys() throws IOException, NullPointerException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/keys.txt")));
            for (KeyPlaceholder keyBinding : Core.getInstance().getKeyMappings()) {
                writer.print(keyBinding.name + ":" + keyBinding.key + (String)(keyBinding.modifier == null ? "" : ":" + keyBinding.modifier) + "\n");
            }
        }
        BufferedReader reader = null;
        if (new File(Core.getInstance().getMCDataDir(), "options.justenoughkeys.txt").exists()) {
            try {
                String line;
                writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/options.justenoughkeys.txt")));
                reader = new BufferedReader(new FileReader(new File(Core.getInstance().getMCDataDir(), "options.justenoughkeys.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
        if (new File(Core.getInstance().getMCDataDir(), "options.amecsapi.txt").exists()) {
            try {
                String line;
                writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/options.amecsapi.txt")));
                reader = new BufferedReader(new FileReader(new File(Core.getInstance().getMCDataDir(), "options.amecsapi.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static boolean saveOptions() throws NullPointerException, IOException {
        String line;
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/options.txt")));
            reader = new BufferedReader(new FileReader(new File(Core.getInstance().getMCDataDir(), "options.txt")));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!new File(Core.getInstance().getMCDataDir(), "optionsof.txt").exists()) {
            return false;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/optionsof.txt")));
            reader = new BufferedReader(new FileReader(new File(Core.getInstance().getMCDataDir(), "optionsof.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!new File(Core.getInstance().getMCDataDir(), "optionsshaders.txt").exists()) {
            return false;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(Core.getInstance().getMainFolder(), Core.getInstance().getActiveProfile() + "/optionsshaders.txt")));
            reader = new BufferedReader(new FileReader(new File(Core.getInstance().getMCDataDir(), "optionsshaders.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        return true;
    }

    public static int saveProcess(final Object source, final String argument, final String argument2) throws Exception {
        if (tpe.getQueue().size() > 0) {
            Exception e = Core.getInstance().throwFailedException();
            if (e != null) {
                throw e;
            }
            Core.getInstance().sendSuccess(source, "Please wait until the last request has finished", ChatColors.RED.ordinal());
            return 0;
        }
        if (Core.getInstance().hasDSShutDown()) {
            Core.getInstance().sendSuccess(source, "DefaultSettings is missing the JCPlugin mod! Shutting down...", ChatColors.RED.ordinal());
            if (Core.getInstance().shutdownReason() != null && !Core.getInstance().shutdownReason().isEmpty()) {
                Core.getInstance().sendSuccess(source, "Reason: " + Core.getInstance().shutdownReason(), ChatColors.RED.ordinal());
            }
            return 0;
        }
        if (!CoreUtil.shouldExecute(source)) {
            return 0;
        }
        if ((Core.getInstance().keysFileExist() || Core.getInstance().optionsFilesExist() || Core.getInstance().serversFileExists()) && (argument == null || !argument.equals("override") && !argument.equals("forceOverride"))) {
            Core.getInstance().sendSuccess(source, "These files already exist! If you want to overwrite", ChatColors.GOLD.ordinal());
            Core.getInstance().sendSuccess(source, "them, add the 'override' argument", ChatColors.GOLD.ordinal());
            return 0;
        }
        MutableBoolean issue = new MutableBoolean(false);
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    boolean somethingChanged = Core.getInstance().checkChanged();
                    if (somethingChanged && !argument.equals("forceOverride")) {
                        Core.getInstance().sendSuccess(source, "\n\n", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "You seem to have updated certain config files!", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "Users who already play your pack won't (!) receive those changes.\n", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "If you want to ship the new configs to those players too,", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "append the 'forceOverride' argument instead of 'override'", ChatColors.GOLD.ordinal());
                    }
                }
                catch (Exception e) {
                    Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("keybinds")) {
                        Core.getInstance().saveKeys();
                        Core.getInstance().sendSuccess(source, "Successfully saved the key configuration", ChatColors.GREEN.ordinal());
                        Core.getInstance().restoreKeys(true, false);
                    }
                }
                catch (Exception e) {
                    Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving the key configuration:", (Throwable)e);
                    Core.getInstance().sendSuccess(source, "Couldn't save the key configuration!", ChatColors.RED.ordinal());
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("options")) {
                        boolean optifine = Core.getInstance().saveOptions();
                        Core.getInstance().sendSuccess(source, "Successfully saved the default game options" + (optifine ? " (+ Optifine)" : ""), ChatColors.GREEN.ordinal());
                    }
                }
                catch (Exception e) {
                    Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving the default game options:", (Throwable)e);
                    Core.getInstance().sendSuccess(source, "Couldn't save the default game options!", ChatColors.RED.ordinal());
                    this.issue.setBoolean(true);
                }
            }
        });
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    if (argument2 == null || argument2.equals("servers")) {
                        Core.getInstance().saveServers();
                        Core.getInstance().sendSuccess(source, "Successfully saved the server list", ChatColors.GREEN.ordinal());
                    }
                }
                catch (Exception e) {
                    Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                    Core.getInstance().sendSuccess(source, "Couldn't save the server list!", ChatColors.RED.ordinal());
                    this.issue.setBoolean(true);
                }
                if (this.issue.getBoolean()) {
                    Core.getInstance().sendSuccess(source, "Please inspect the log files for further information!", ChatColors.YELLOW.ordinal());
                } else {
                    try {
                        boolean updateExisting = argument != null && argument.equals("forceOverride");
                        Core.getInstance().checkMD5(updateExisting, false, null);
                        Core.getInstance().copyAndHashPrivate(true, false);
                    }
                    catch (IOException e) {
                        Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving your configuration:", (Throwable)e);
                    }
                }
            }
        });
        return 0;
    }

    private static boolean shouldExecute(Object source) {
        if (Core.getInstance().isOtherCreator()) {
            if (!Core.getInstance().disableCreatorCheck()) {
                Core.getInstance().sendSuccess(source, "You're not the creator of this modpack! Using these creator-only commands might come with unforeseen problems.", ChatColors.RED.ordinal());
                Core.getInstance().sendSuccess(source, "If you're fine with those risks, you may change `\"disableCreatorCheck\": \"false\"` in the `ds_private_storage.json` file to `true`", ChatColors.RED.ordinal());
                return false;
            }
            Core.getInstance().sendSuccess(source, "Caution! You disabled the creator checker! This might break things!", ChatColors.RED.ordinal());
            return true;
        }
        return true;
    }

    public static int saveProcessConfigs(final Object source, final String argument, final String argument2) throws Exception {
        if (tpe.getQueue().size() > 0) {
            Exception e = Core.getInstance().throwFailedException();
            if (e != null) {
                throw e;
            }
            Core.getInstance().sendSuccess(source, "Please wait until the last request has finished", ChatColors.RED.ordinal());
            return 0;
        }
        if (Core.getInstance().hasDSShutDown()) {
            Core.getInstance().sendSuccess(source, "DefaultSettings is missing the JCPlugin mod! Shutting down...", ChatColors.RED.ordinal());
            if (Core.getInstance().shutdownReason() != null && !Core.getInstance().shutdownReason().isEmpty()) {
                Core.getInstance().sendSuccess(source, "Reason: " + Core.getInstance().shutdownReason(), ChatColors.RED.ordinal());
            }
            return 0;
        }
        if (!CoreUtil.shouldExecute(source)) {
            return 0;
        }
        MutableBoolean issue = new MutableBoolean(false);
        tpe.execute(new ThreadRunnable(source, issue){

            @Override
            public void run() {
                try {
                    boolean somethingChanged = Core.getInstance().checkChangedConfig();
                    if (somethingChanged && (argument == null || !argument.equals("forceOverride"))) {
                        Core.getInstance().sendSuccess(source, "\n\n", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "You seem to have updated certain config files!", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "Users who already play your pack won't (!) receive those changes.\n", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "If you want to ship the new configs to those players too,", ChatColors.GOLD.ordinal());
                        Core.getInstance().sendSuccess(source, "append the 'forceOverride' argument", ChatColors.GOLD.ordinal());
                    }
                }
                catch (Exception e) {
                    Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving the server list:", (Throwable)e);
                    Core.getInstance().sendSuccess(source, "Couldn't save the config files!", ChatColors.RED.ordinal());
                    this.issue.setBoolean(true);
                }
                if (this.issue.getBoolean()) {
                    Core.getInstance().sendSuccess(source, "Please inspect the log files for further information!", ChatColors.YELLOW.ordinal());
                } else {
                    try {
                        boolean updateExisting = argument != null && argument.equals("forceOverride");
                        Core.getInstance().checkMD5(updateExisting, true, argument2 == null ? null : argument2);
                        Core.getInstance().copyAndHashPrivate(false, true);
                        Core.getInstance().sendSuccess(source, "Successfully saved your mod configuration files" + (argument2 == null ? "" : (argument2.contains("*") ? " (wildcard)" : " (single entry)")), ChatColors.GREEN.ordinal());
                        boolean noFiles = Core.getInstance().checkForConfigFiles();
                        if (noFiles) {
                            Core.getInstance().sendSuccess(source, "Warning: No config files will be shipped as the folder is still empty!", ChatColors.YELLOW.ordinal());
                        }
                    }
                    catch (IOException | UncheckedIOException | NullPointerException e) {
                        Core.getInstance().sendSuccess(source, "Couldn't save the config files!", ChatColors.RED.ordinal());
                        if (e instanceof UncheckedIOException && e.getCause() instanceof NoSuchFileException) {
                            Core.getInstance().sendSuccess(source, "It seems, no file or folder by that name exists", ChatColors.RED.ordinal());
                        }
                        Core.getInstance().getDSLog().log(Level.ERROR, "An exception occurred while saving your configuration:", (Throwable)e);
                    }
                }
            }
        });
        return 0;
    }
}

