/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client.gui.quests;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.client.gui.ContextMenuBuilder;
import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.quest.reward.ItemReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class RewardButton
extends Button {
    private final QuestScreen questScreen;
    private final Reward reward;

    public RewardButton(Panel panel, Reward reward) {
        super(panel, reward.getTitle(), reward.getIcon());
        this.questScreen = (QuestScreen)panel.getGui();
        this.reward = reward;
        this.setSize(18, 18);
    }

    public Component getTitle() {
        if (this.reward.isTeamReward()) {
            return super.getTitle().m_6881_().m_130940_(ChatFormatting.BLUE);
        }
        return super.getTitle();
    }

    public void addMouseOverText(TooltipList list) {
        this.questScreen.addInfoTooltip(list, this.reward);
        if (this.reward.addTitleInMouseOverText()) {
            Reward reward = this.reward;
            if (reward instanceof ItemReward) {
                ItemReward itemReward = (ItemReward)reward;
                TooltipFlag.Default flag = Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
                itemReward.getItem().m_41651_(FTBQuestsClient.getClientPlayer(), (TooltipFlag)flag).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            } else {
                list.add(this.getTitle());
            }
        }
        if (this.reward.isTeamReward() || this.questScreen.file.selfTeamData.isRewardBlocked(this.reward)) {
            this.getIngredientUnderMouse().ifPresent(ingredient -> {
                ItemStack stack;
                Object patt2238$temp;
                if (ingredient.tooltip() && (patt2238$temp = ingredient.ingredient()) instanceof ItemStack && !(stack = (ItemStack)patt2238$temp).m_41619_()) {
                    ArrayList list1 = new ArrayList();
                    GuiHelper.addStackTooltip((ItemStack)stack, list1);
                    list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
                }
            });
            list.blankLine();
            this.reward.addMouseOverText(list);
            if (this.reward.isTeamReward()) {
                list.add((Component)Component.m_237115_((String)"ftbquests.reward.team_reward").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}));
            } else if (this.questScreen.file.selfTeamData.isRewardBlocked(this.reward)) {
                list.add((Component)Component.m_237110_((String)"ftbquests.reward.this_blocked", (Object[])new Object[]{this.questScreen.file.selfTeamData}).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            }
        } else {
            this.reward.addMouseOverText(list);
            if (!list.shouldRender()) {
                list.zOffset = 580;
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!ClientQuestFile.exists() || !ClientQuestFile.INSTANCE.selfTeamData.isCompleted(this.reward.getQuest())) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.exists()) {
                this.reward.onButtonClicked(this, ClientQuestFile.INSTANCE.selfTeamData.getClaimType(Minecraft.m_91087_().f_91074_.m_20148_(), this.reward).canClaim());
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            this.playClickSound();
            ContextMenuBuilder.create(this.reward, this.questScreen).openContextMenu(this.getGui());
        }
    }

    public Optional<PositionedIngredient> getIngredientUnderMouse() {
        return PositionedIngredient.of(this.reward.getIngredient((Widget)this), (Widget)this);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isMouseOver()) {
            super.drawBackground(graphics, theme, x, y, w, h);
        }
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        String s;
        int bs = h >= 32 ? 32 : 16;
        GuiHelper.setupDrawing();
        this.drawBackground(graphics, theme, x, y, w, h);
        this.drawIcon(graphics, theme, x + (w - bs) / 2, y + (h - bs) / 2, bs, bs);
        if (this.questScreen.file.selfTeamData == null) {
            return;
        }
        if (this.questScreen.getContextMenu().isEmpty()) {
            // empty if block
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        RenderSystem.enableBlend();
        boolean completed = false;
        if (this.questScreen.file.selfTeamData.getClaimType(Minecraft.m_91087_().f_91074_.m_20148_(), this.reward).isClaimed()) {
            ((Icon)ThemeProperties.CHECK_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
            completed = true;
        } else if (this.questScreen.file.selfTeamData.isCompleted(this.reward.getQuest())) {
            ((Icon)ThemeProperties.ALERT_ICON.get()).draw(graphics, x + w - 9, y + 1, 8, 8);
        }
        poseStack.m_85849_();
        if (!completed && !(s = this.reward.getButtonText()).isEmpty()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(x + 19) - (double)theme.getStringWidth(s) / 2.0, (double)(y + 15), 200.0);
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            theme.drawString(graphics, (Object)s, 0, 0, Color4I.WHITE, 2);
            poseStack.m_85849_();
        }
    }
}

