/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import com.google.common.collect.ImmutableList;
import dev.djefrey.colorwheel.compile.ClrwlPipelineCompiler;
import dev.djefrey.colorwheel.compile.ClrwlPipelines;
import dev.djefrey.colorwheel.compile.ClrwlProgram;
import dev.djefrey.colorwheel.compile.ClrwlShaderKey;
import dev.djefrey.colorwheel.compile.oit.ClrwlOitPrograms;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;

public class ClrwlPrograms {
    public static final List<String> EXTENSIONS = ClrwlPrograms.getExtensions(GlCompat.MAX_GLSL_VERSION);
    private final ClrwlPipelineCompiler compiler;
    private final ClrwlOitPrograms oitPrograms;
    private final Map<ClrwlShaderKey, ClrwlProgram> programCache = new HashMap<ClrwlShaderKey, ClrwlProgram>();

    private ClrwlPrograms(ClrwlPipelineCompiler compiler, ClrwlOitPrograms oitPrograms) {
        this.compiler = compiler;
        this.oitPrograms = oitPrograms;
    }

    private static List<String> getExtensions(GlslVersion glslVersion) {
        ImmutableList.Builder extensions = ImmutableList.builder();
        if (glslVersion.compareTo((Enum)GlslVersion.V330) < 0) {
            extensions.add((Object)"GL_ARB_shader_bit_encoding");
        }
        return extensions.build();
    }

    public static ClrwlPrograms build(ShaderSources sources, ShaderPack pack, NamespacedId dimension) {
        if (!GlCompat.SUPPORTS_INSTANCING) {
            return null;
        }
        ClrwlPipelineCompiler compiler = new ClrwlPipelineCompiler(sources, ClrwlPipelines.INSTANCING, pack, dimension);
        ClrwlOitPrograms oit = new ClrwlOitPrograms(sources);
        return new ClrwlPrograms(compiler, oit);
    }

    public ClrwlProgram get(ClrwlShaderKey key) {
        ClrwlProgram program = this.programCache.get(key);
        if (program == null) {
            program = this.compiler.get(key);
            this.programCache.put(key, program);
        }
        return program;
    }

    private void deleteCache() {
        for (ClrwlProgram program : this.programCache.values()) {
            program.free();
        }
        this.programCache.clear();
    }

    public void delete() {
        this.deleteCache();
    }

    public ClrwlOitPrograms getOitPrograms() {
        return this.oitPrograms;
    }
}

