/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismClientConfig {
    public final VisualSettings visuals;
    public final MiscSettings misc;
    public final ForgeConfigSpec spec;

    public OccultismClientConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.visuals = new VisualSettings(builder);
        this.misc = new MiscSettings(builder);
        this.spec = builder.build();
    }

    public static class VisualSettings {
        public final ForgeConfigSpec.BooleanValue showItemTagsInTooltip;
        public final ForgeConfigSpec.BooleanValue disableDemonsDreamShaders;
        public final ForgeConfigSpec.BooleanValue disableHolidayTheming;
        public final ForgeConfigSpec.BooleanValue useAlternativeDivinationRodRenderer;
        public final ForgeConfigSpec.ConfigValue<Integer> whiteChalkGlyphColor;
        public final ForgeConfigSpec.ConfigValue<Integer> goldenChalkGlyphColor;
        public final ForgeConfigSpec.ConfigValue<Integer> purpleChalkGlyphColor;
        public final ForgeConfigSpec.ConfigValue<Integer> redChalkGlyphColor;

        public VisualSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Visual Settings").push("visual");
            this.showItemTagsInTooltip = builder.comment("Shows all tags an item has in the tooltip on hover if advanced tooltips (F3+H) are enabled.").define("showItemTagsInTooltip", false);
            this.disableDemonsDreamShaders = builder.comment("Disables the headache- and possibly seizure-inducing visual effects of Demon's Dream.").define("disableDemonsDreamShaders", false);
            this.disableHolidayTheming = builder.comment("Disables holiday themed visual content such as familiar skins.").define("disableHolidayTheming", false);
            this.useAlternativeDivinationRodRenderer = builder.comment(new String[]{"When true the old divination rod selected block renderer will be used.", "May work for some people that do not see selected block outlines when using the divination rod."}).define("useAlternativeDivinationRodRenderer", false);
            this.whiteChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the white chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).define("whiteChalkGlyphColor", (Object)0xFFFFFF);
            this.goldenChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the golden chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).define("goldenChalkGlyphColor", (Object)15783680);
            this.purpleChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the purple chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).define("purpleChalkGlyphColor", (Object)10224531);
            this.redChalkGlyphColor = builder.comment(new String[]{"The integer code of the  color of the red chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness this value should be changed to a green color, we recommend 33289 (= Hex 0x008209)"}).define("redChalkGlyphColor", (Object)0xCC0101);
            builder.pop();
        }
    }

    public static class MiscSettings {
        public final ForgeConfigSpec.BooleanValue syncJeiSearch;
        public final ForgeConfigSpec.BooleanValue divinationRodHighlightAllResults;
        public final ForgeConfigSpec.IntValue divinationRodScanRange;
        public final ForgeConfigSpec.BooleanValue disableSpiritFireSuccessSound;

        public MiscSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("Misc Settings").push("misc");
            this.syncJeiSearch = builder.comment("Sync JEI search in storage actuator.").define("syncJeiSearch", false);
            this.divinationRodHighlightAllResults = builder.comment(new String[]{"If true, divination rod will render all matching blocks with an outline. Disable if it causes lag.", "This setting will be unused, if Theurgy is installed alongside, as Occultism will use Theurgy's divination rod result rendering instead."}).define("divinationRodHighlightAllResults", false);
            this.divinationRodScanRange = builder.comment("The scan range in blocks for the divination rod. Too high might cause lags").defineInRange("divinationRodScanRange", 129, 1, Integer.MAX_VALUE);
            this.disableSpiritFireSuccessSound = builder.comment("Disables the sound played when a spirit fire successfully crafted an item.").define("disableSpiritFireSuccessSound", false);
            builder.pop();
        }
    }
}

