/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.SavedTeleportManager;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HomeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (FTBEConfig.HOME.isEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"home").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.home(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(HomeCommands.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.home(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sethome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.setHome(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> HomeCommands.setHome(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"delhome").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.delHome(((CommandSourceStack)context.getSource()).m_81375_(), "home"))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> SharedSuggestionProvider.m_82970_(HomeCommands.getHomeSuggestions((CommandContext<CommandSourceStack>)context), (SuggestionsBuilder)builder)).executes(context -> HomeCommands.delHome(((CommandSourceStack)context.getSource()).m_81375_(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"listhomes").requires((Predicate)FTBEConfig.HOME)).executes(context -> HomeCommands.listHomes((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_().m_36316_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).executes(context -> HomeCommands.listHomes((CommandSourceStack)context.getSource(), (GameProfile)GameProfileArgument.m_94590_((CommandContext)context, (String)"player").iterator().next()))));
        }
    }

    public static Set<String> getHomeSuggestions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return FTBEPlayerData.getOrCreate((Player)((CommandSourceStack)context.getSource()).m_81375_()).map(data -> data.homeManager().getNames()).orElse(Set.of());
    }

    public static int home(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> data.homeManager().teleportTo(name, player, data.homeTeleporter).runCommand(player)).orElse(0);
    }

    public static int setHome(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            try {
                data.homeManager().addDestination(name, new TeleportPos((Entity)player), player);
                player.m_5661_((Component)Component.m_237113_((String)"Home set!"), false);
                return 1;
            }
            catch (SavedTeleportManager.TooManyDestinationsException e) {
                player.m_5661_((Component)Component.m_237113_((String)"Can't add any more homes!"), false);
                return 0;
            }
        }).orElse(0);
    }

    public static int delHome(ServerPlayer player, String name) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            if (data.homeManager().deleteDestination(name.toLowerCase())) {
                player.m_5661_((Component)Component.m_237113_((String)"Home deleted!"), false);
                return 1;
            }
            player.m_5661_((Component)Component.m_237113_((String)"Home not found!"), false);
            return 0;
        }).orElse(0);
    }

    public static int listHomes(CommandSourceStack source, GameProfile of) {
        return FTBEPlayerData.getOrCreate(of).map(data -> {
            if (data.homeManager().getNames().isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"None"), false);
            } else {
                TeleportPos origin = new TeleportPos((ResourceKey<Level>)source.m_81372_().m_46472_(), BlockPos.m_274446_((Position)source.m_81371_()));
                data.homeManager().destinations().forEach(entry -> source.m_288197_(() -> Component.m_237113_((String)(entry.name() + ": " + entry.destination().distanceString(origin))), false));
            }
            return 1;
        }).orElse(0);
    }
}

