/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.util.DamageSourceExtension;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class MagicalArrowAffix
extends Affix {
    public static final Codec<MagicalArrowAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.CODEC.fieldOf("min_rarity").forGetter(a -> a.minRarity)).apply((Applicative)inst, MagicalArrowAffix::new));
    protected LootRarity minRarity;

    public MagicalArrowAffix(LootRarity minRarity) {
        super(AffixType.ABILITY);
        this.minRarity = minRarity;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat.isRanged() && rarity.isAtLeast(this.minRarity);
    }

    public void onHurt(LivingHurtEvent e) {
        AbstractArrow arrow;
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof AbstractArrow && AffixHelper.getAffixes(arrow = (AbstractArrow)entity).containsKey(Apoth.Affixes.MAGICAL)) {
            ((DamageSourceExtension)e.getSource()).addTag((TagKey<DamageType>)DamageTypeTags.f_268490_);
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

