/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingMenu;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import dev.shadowsoffire.apotheosis.adventure.client.DropDownList;
import dev.shadowsoffire.apotheosis.adventure.client.SimpleTexButton;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class AugmentingScreen
extends AdventureContainerScreen<AugmentingMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/augmenting.png");
    public static final int ALTERNATIVE_TEXT_WIDTH = 150;
    public static final int ALTERNATIVE_MAX_LINES = 15;
    protected ItemStack lastMainItem = ItemStack.f_41583_;
    protected int lastSelection = -1;
    protected List<AffixInstance> currentItemAffixes = Collections.emptyList();
    protected int alternativePage = -1;
    protected List<List<FormattedText>> alternativePages = Collections.emptyList();
    protected int alternativeXPos = 0;
    protected int alternativeWidth = 0;
    protected AffixDropList list;
    protected SimpleTexButton upgradeBtn;
    protected SimpleTexButton rerollBtn;

    public AugmentingScreen(AugmentingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int selected = this.getSelectedAffix();
        this.list = (AffixDropList)this.m_142416_((GuiEventListener)new AffixDropList(left + 39, top + 17, 123, 14, (Component)Component.m_237119_(), this.currentItemAffixes, 6));
        this.list.setSelected(selected);
        MutableComponent sigilName = Component.m_237115_((String)"item.apotheosis.sigil_of_enhancement").m_130940_(ChatFormatting.YELLOW);
        this.upgradeBtn = (SimpleTexButton)this.m_142416_((GuiEventListener)new FatTexButton(left + 60, top + 111, 29, 13, 186, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.f_96541_.f_91072_.m_105208_(((AugmentingMenu)this.f_97732_).f_38840_, 0 | this.getSelectedAffix() << 1);
            }
        }, (Component)Component.m_237115_((String)"button.apotheosis.augmenting.upgrade"), (Component)Component.m_237110_((String)"button.apotheosis.augmenting.upgrade.cost", (Object[])new Object[]{2, sigilName})));
        this.rerollBtn = (SimpleTexButton)this.m_142416_((GuiEventListener)new FatTexButton(left + 112, top + 111, 29, 13, 223, 135, btn -> {
            if (this.getSelectedAffix() != -1) {
                this.f_96541_.f_91072_.m_105208_(((AugmentingMenu)this.f_97732_).f_38840_, 1 | this.getSelectedAffix() << 1);
            }
        }, (Component)Component.m_237115_((String)"button.apotheosis.augmenting.reroll"), (Component)Component.m_237110_((String)"button.apotheosis.augmenting.upgrade.cost", (Object[])new Object[]{1, sigilName})));
    }

    protected void m_7286_(GuiGraphics gfx, float partialTick, int mouseX, int mouseY) {
        AffixInstance inst;
        this.updateCachedState();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        gfx.m_280163_(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 307);
        int selected = this.getSelectedAffix();
        if (selected != -1 && !this.list.isOpen()) {
            inst = this.currentItemAffixes.get(selected);
            Component comp = inst.getAugmentingText();
            List split = this.f_96547_.m_92923_((FormattedText)comp, 117);
            for (int i = 0; i < split.size(); ++i) {
                gfx.m_280649_(this.f_96547_, (FormattedCharSequence)split.get(i), left + 43, top + 40 + i * 11, ChatFormatting.YELLOW.m_126665_().intValue(), true);
            }
            int bgColor = -267386864;
            int borderColor = -13220529;
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)(left + 42), (int)(top + 39), (int)117, (int)65, (int)0, (int)bgColor, (int)bgColor, (int)borderColor, (int)borderColor);
        } else {
            int bgColor = -1441787888;
            int borderColor = -1439283889;
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gfx, (int)(left + 42), (int)(top + 39), (int)117, (int)65, (int)0, (int)bgColor, (int)bgColor, (int)borderColor, (int)borderColor);
        }
        if (selected != -1 && this.rerollBtn.m_274382_() && this.rerollBtn.m_142518_() && this.alternativePage != -1) {
            List<FormattedText> page = this.alternativePages.get(this.alternativePage);
            List list = page.stream().map(arg_0 -> ((Language)Language.m_128107_()).m_5536_(arg_0)).map(ClientTooltipComponent::m_169948_).collect(Collectors.toCollection(Lists::newArrayList));
            if (this.alternativePages.size() > 1) {
                list.set(list.size() - 2, new FakeWidthComponent(this.alternativeWidth));
            }
            gfx.m_280497_(this.f_96547_, list, this.alternativeXPos, this.getGuiTop() + 33, DefaultTooltipPositioner.f_262752_);
        }
        if (selected != -1 && this.upgradeBtn.m_142518_() && this.upgradeBtn.m_274382_()) {
            inst = this.currentItemAffixes.get(selected);
            AffixInstance upgraded = new AffixInstance(inst.affix(), inst.stack(), inst.rarity(), Math.min(1.0f, inst.level() + 0.25f));
            ArrayList<MutableComponent> altText = new ArrayList<MutableComponent>();
            altText.add(Component.m_237115_((String)"text.apotheosis.upgraded_form").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE}));
            altText.add(Component.m_237110_((String)"%s", (Object[])new Object[]{upgraded.getAugmentingText()}).m_130940_(ChatFormatting.YELLOW));
            this.drawOnLeft(gfx, altText, top + 33, 150);
        }
    }

    protected void updateCachedState() {
        int selected;
        ItemStack mainItem = ((AugmentingMenu)this.f_97732_).getMainItem();
        if (!ItemStack.m_150942_((ItemStack)mainItem, (ItemStack)this.lastMainItem)) {
            List<AffixInstance> newAffixes = AugmentingMenu.computeItemAffixes(mainItem);
            if (ItemStack.m_41656_((ItemStack)mainItem, (ItemStack)this.lastMainItem) && this.currentItemAffixes.size() == newAffixes.size()) {
                this.list.setEntries(newAffixes);
                this.list.setSelected(this.lastSelection);
            } else {
                this.list.setEntries(newAffixes);
            }
            this.currentItemAffixes = newAffixes;
            this.lastMainItem = mainItem.m_41777_();
            this.computeAlternatives(this.list.getSelected());
        }
        if (this.lastSelection != this.list.getSelected()) {
            this.lastSelection = this.list.getSelected();
            this.computeAlternatives(this.lastSelection);
        }
        if ((selected = this.getSelectedAffix()) == -1) {
            MutableComponent comp = Component.m_237115_((String)"button.apotheosis.augmenting.no_selection").m_130940_(ChatFormatting.RED);
            this.upgradeBtn.f_93623_ = false;
            this.upgradeBtn.setInactiveMessage((Component)comp);
            this.rerollBtn.f_93623_ = false;
            this.rerollBtn.setInactiveMessage((Component)comp);
        } else {
            this.upgradeBtn.f_93623_ = true;
            this.rerollBtn.f_93623_ = true;
            AffixInstance current = this.currentItemAffixes.get(selected);
            if (current.level() >= 1.0f) {
                this.upgradeBtn.f_93623_ = false;
                this.upgradeBtn.setInactiveMessage((Component)Component.m_237115_((String)"button.apotheosis.augmenting.max_level").m_130940_(ChatFormatting.RED));
            }
            if (this.alternativePages.isEmpty()) {
                this.rerollBtn.f_93623_ = false;
                this.rerollBtn.setInactiveMessage((Component)Component.m_237115_((String)"button.apotheosis.augmenting.no_alternatives").m_130940_(ChatFormatting.RED));
            }
            if (this.upgradeBtn.m_142518_() && ((AugmentingMenu)this.f_97732_).getSigils().m_41613_() < 2 && !((AugmentingMenu)this.f_97732_).player.m_7500_()) {
                this.upgradeBtn.f_93623_ = false;
                this.upgradeBtn.setInactiveMessage((Component)Component.m_237115_((String)"Not Enough Sigils").m_130940_(ChatFormatting.RED));
            }
            if (this.rerollBtn.m_142518_() && ((AugmentingMenu)this.f_97732_).getSigils().m_41613_() < 1 && !((AugmentingMenu)this.f_97732_).player.m_7500_()) {
                this.rerollBtn.f_93623_ = false;
                this.rerollBtn.setInactiveMessage((Component)Component.m_237115_((String)"Not Enough Sigils").m_130940_(ChatFormatting.RED));
            }
        }
    }

    protected void computeAlternatives(int selected) {
        if (selected == -1) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
            return;
        }
        AffixInstance current = this.currentItemAffixes.get(selected);
        List<DynamicHolder<? extends Affix>> alternatives = LootController.getAvailableAffixes(this.lastMainItem, (LootRarity)current.rarity().get(), this.currentItemAffixes.stream().map(AffixInstance::affix).collect(Collectors.toSet()), ((Affix)current.affix().get()).getType());
        if (alternatives.isEmpty()) {
            this.alternativePages = Collections.emptyList();
            this.alternativePage = -1;
        } else {
            StringSplitter splitter = this.f_96547_.m_92865_();
            int maxWidth = 0;
            MutableComponent heading = Component.m_237115_((String)"text.apotheosis.potential_rerolls").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
            ArrayList<List<FormattedText>> pages = new ArrayList<List<FormattedText>>();
            ArrayList<Object> page = new ArrayList<Object>();
            page.add(heading);
            boolean first = true;
            for (DynamicHolder<? extends Affix> afx : alternatives) {
                Component augTxt = ((Affix)afx.get()).getAugmentingText(current.stack(), (LootRarity)current.rarity().get(), current.level());
                List split = splitter.m_92414_((FormattedText)Component.m_237110_((String)"%s", (Object[])new Object[]{augTxt}).m_130940_(ChatFormatting.YELLOW), 150, augTxt.m_7383_());
                maxWidth = Math.max(maxWidth, split.stream().map(arg_0 -> ((Font)this.ths().f_96547_).m_92852_(arg_0)).max(Integer::compare).get());
                if (page.size() + split.size() + 1 > 15) {
                    pages.add(page);
                    page = new ArrayList();
                    page.add(heading);
                    page.addAll(split);
                } else {
                    if (!first) {
                        page.add(CommonComponents.f_263701_);
                    }
                    page.addAll(split);
                    first = false;
                }
                if (afx != alternatives.get(alternatives.size() - 1)) continue;
                pages.add(page);
            }
            this.alternativePage = 0;
            this.alternativePages = pages;
            this.alternativeXPos = this.ths().getGuiLeft() - 16 - maxWidth;
            this.alternativeWidth = maxWidth;
            int pages2 = this.alternativePages.size();
            if (pages2 > 1) {
                for (int i = 0; i < pages2; ++i) {
                    List<FormattedText> page2 = this.alternativePages.get(i);
                    page2.add((FormattedText)CommonComponents.f_263701_);
                    page2.add((FormattedText)Component.m_237110_((String)"text.apotheosis.alternative_page", (Object[])new Object[]{i + 1, pages2}).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    protected int getSelectedAffix() {
        return this.list == null ? -1 : this.list.getSelected();
    }

    public static void handleRerollResult(DynamicHolder<? extends Affix> newAffix) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AugmentingScreen) {
            AugmentingScreen scn = (AugmentingScreen)screen;
            scn.updateCachedState();
            for (int i = 0; i < scn.currentItemAffixes.size(); ++i) {
                AffixInstance inst = scn.currentItemAffixes.get(i);
                if (!inst.affix().equals(newAffix)) continue;
                scn.list.setSelected(i);
                return;
            }
        }
    }

    public class AffixDropList
    extends DropDownList<AffixInstance> {
        public AffixDropList(int x, int y, int width, int height, Component narrationMsg, List<AffixInstance> entries, int maxDisplayedEntries) {
            super(x, y, width, height, narrationMsg, entries, maxDisplayedEntries);
        }

        @Override
        protected void m_87963_(GuiGraphics gfx, int mouseX, int mouseY, float partialTick) {
            gfx.m_280168_().m_85836_();
            gfx.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            if (this.entries.isEmpty()) {
                gfx.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 0.0f, 267.0f, this.f_93618_, this.baseHeight, 256, 307);
            }
            super.m_87963_(gfx, mouseX, mouseY, partialTick);
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            if (this.isOpen && hovered != -1) {
                AffixInstance inst = (AffixInstance)this.entries.get(hovered);
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                list.add(inst.getName(true).m_6881_().m_130948_(Style.f_131099_.m_178520_(0xFFFF80).m_131162_(Boolean.valueOf(true))));
                list.add(Component.m_237110_((String)"%s", (Object[])new Object[]{inst.getAugmentingText()}).m_130940_(ChatFormatting.YELLOW));
                AugmentingScreen.this.drawOnLeft(gfx, list, AugmentingScreen.this.getGuiTop() + 33, 150);
            }
            gfx.m_280163_(TEXTURE, this.m_252754_() + this.f_93618_ - 15, this.m_252907_(), (float)(123 + (this.isOpen ? 15 : 0)), 239.0f, 15, 14, 256, 307);
            gfx.m_280168_().m_85849_();
        }

        @Override
        protected void renderEntry(GuiGraphics gfx, int x, int y, int mouseX, int mouseY, AffixInstance entry) {
            int idx;
            int hovered = this.getHoveredSlot(mouseX, mouseY);
            gfx.m_280163_(TEXTURE, x, y, 0.0f, (float)(239 + (hovered == (idx = this.entries.indexOf(entry)) ? this.baseHeight : 0)), this.f_93618_, this.baseHeight, 256, 307);
            gfx.m_280430_(AugmentingScreen.this.f_96547_, entry.getName(true), x + 2, y + 3, 0xFFFF80);
        }
    }

    public class FatTexButton
    extends SimpleTexButton {
        protected final Component costMsg;

        public FatTexButton(int x, int y, int width, int height, int u, int v, Button.OnPress press, Component message, Component costMsg) {
            super(x, y, width, height, u, v, TEXTURE, 256, 307, press, message);
            this.costMsg = costMsg;
        }

        @Override
        public void m_87963_(GuiGraphics gfx, int pMouseX, int pMouseY, float pPartialTick) {
            int yTex = this.yTexStart - 2;
            if (!this.m_142518_()) {
                yTex += this.f_93619_ + 4;
            } else if (this.m_274382_()) {
                yTex += (this.f_93619_ + 4) * 2;
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            gfx.m_280163_(this.texture, this.m_252754_() - 2, this.m_252907_() - 2, (float)(this.xTexStart - 2), (float)yTex, this.f_93618_ + 4, this.f_93619_ + 4, this.textureWidth, this.textureHeight);
            if (this.m_274382_()) {
                this.renderToolTip(gfx, pMouseX, pMouseY);
            }
        }

        @Override
        public void renderToolTip(GuiGraphics gfx, int pMouseX, int pMouseY) {
            if (this.m_6035_() != CommonComponents.f_237098_ && this.m_274382_()) {
                Component primary = this.m_6035_();
                if (!this.f_93623_) {
                    primary = primary.m_6881_().m_130940_(ChatFormatting.GRAY);
                }
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.add(primary);
                if (this.m_142518_()) {
                    tooltips.add(this.costMsg);
                } else if (this.inactiveMessage != CommonComponents.f_237098_) {
                    tooltips.add(this.inactiveMessage);
                }
                gfx.m_280666_(Minecraft.m_91087_().f_91062_, tooltips, pMouseX, pMouseY);
            }
        }

        public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
            if (this == AugmentingScreen.this.rerollBtn && this.m_142518_() && this.m_274382_()) {
                int change = pDelta < 0.0 ? 1 : -1;
                int page = AugmentingScreen.this.alternativePage;
                AugmentingScreen.this.alternativePage = page = Math.floorMod(page + change, AugmentingScreen.this.alternativePages.size());
                return true;
            }
            return super.m_6050_(pMouseX, pMouseY, pDelta);
        }
    }

    public record FakeWidthComponent(int width) implements ClientTooltipComponent
    {
        public int m_142103_() {
            return 9;
        }

        public int m_142069_(Font pFont) {
            return this.width;
        }
    }
}

