/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.dissolver;

import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilitySet;
import com.smashingmods.alchemistry.datagen.recipe.dissolver.DissolverRecipeProvider;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ChemlibRecipes
extends DissolverRecipeProvider {
    public ChemlibRecipes(Consumer<FinishedRecipe> pConsumer) {
        super(pConsumer);
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new ChemlibRecipes(pConsumer).register();
    }

    protected void register() {
        ItemRegistry.getCompounds().forEach(compoundItem -> {
            ArrayList<ItemStack> components = new ArrayList<ItemStack>();
            compoundItem.getComponents().forEach((name, count) -> {
                Optional optionalElement = ItemRegistry.getElementByName((String)name);
                Optional optionalCompound = ItemRegistry.getCompoundByName((String)name);
                optionalElement.ifPresent(element -> components.add(new ItemStack((ItemLike)element, count.intValue())));
                optionalCompound.ifPresent(compound -> components.add(new ItemStack((ItemLike)compound, count.intValue())));
            });
            this.dissolver((ItemLike)compoundItem, ProbabilitySet.Builder.createSet().addGroup(components, 100.0).build(), true);
        });
        for (CompoundItem compound : ItemRegistry.getCompounds()) {
            if (!compound.getMatterState().equals((Object)MatterState.SOLID)) continue;
            ArrayList<ItemStack> components = new ArrayList<ItemStack>();
            Optional input = ItemRegistry.getChemicalItemByNameAndType((String)compound.getChemicalName(), (ChemicalItemType)ChemicalItemType.COMPOUND);
            components.add(new ItemStack((ItemLike)compound, 8));
            input.ifPresent(chemicalItem -> this.dissolver((ItemLike)chemicalItem, ProbabilitySet.Builder.createSet().addGroup(components).build(), true));
        }
        for (ElementItem element : ItemRegistry.getElementsByMatterState((MatterState)MatterState.SOLID).toList()) {
            String ingotTag = String.format("forge:ingots/%s", element.getChemicalName());
            String nuggetTag = "forge:nuggets/" + element.getChemicalName();
            String dustTag = "forge:dusts/" + element.getChemicalName();
            String plateTag = "forge:plates/" + element.getChemicalName();
            String oreTag = "forge:ores/" + element.getChemicalName();
            String storageBlockTag = "forge:storage_blocks/" + element.getChemicalName();
            if (!element.getChemicalName().equals("sulfur")) {
                this.dissolver(ingotTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 16)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)ingotTag));
                this.dissolver(nuggetTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 1)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)nuggetTag));
                this.dissolver(dustTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 16)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)dustTag));
                this.dissolver(oreTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 32)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)oreTag));
                this.dissolver(storageBlockTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 144)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)storageBlockTag));
            }
            this.dissolver(plateTag, ProbabilitySet.Builder.createSet().addGroup(new ItemStack((ItemLike)element, 16)).build(), (ICondition)DatagenHelpers.tagNotEmptyCondition((String)plateTag));
        }
    }
}

