/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.client.container;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.container.SideModeScreen;
import com.smashingmods.alchemistry.common.network.SetSideConfigurationPacket;
import com.smashingmods.alchemylib.api.storage.SideMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

class SideConfigButton
extends AbstractWidget {
    private static final ResourceLocation ICONS_LOCATION = new ResourceLocation("alchemylib", "textures/gui/widgets.png");
    private static final ResourceLocation BARRIER_LOCATION = new ResourceLocation("minecraft", "textures/item/barrier.png");
    private final SideModeScreen<?> parentScreen;
    @Nullable
    private final Direction side;
    private final List<Component> tooltip;
    private final int baseOffsetX;
    private final int baseOffsetY;

    SideConfigButton(SideModeScreen<?> parentScreen, int rasterX, int rasterY, @Nullable Direction side) {
        super(0, 0, 16, 16, (Component)Component.m_237119_());
        this.parentScreen = parentScreen;
        this.baseOffsetX = 4 + 20 * rasterX;
        this.baseOffsetY = 4 + 20 * rasterY;
        this.side = side;
        this.tooltip = new ArrayList<Component>();
        this.tooltip.add((Component)Component.m_237115_((String)("alchemistry.container.sides." + (side == null ? "external" : side.m_7912_()))));
        this.tooltip.add((Component)Component.m_237113_((String)""));
        this.tooltip.add(this.getCurrentModeComponent());
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        pNarrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.tooltip.get(0).m_6879_().m_130946_(" ").m_7220_(this.tooltip.get(2)));
    }

    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_252865_(this.baseOffsetX + this.parentScreen.getRasterStartX());
        this.m_253211_(this.baseOffsetY + this.parentScreen.getMinY());
        int backgroundColor = this.m_198029_() ? -1 : -3092272;
        pGuiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93618_, -16777216);
        pGuiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + this.f_93618_ - 1, backgroundColor);
        switch (this.getCurrentMode()) {
            case DISABLED: {
                pGuiGraphics.m_280411_(BARRIER_LOCATION, this.m_252754_() + 4, this.m_252907_() + 4, this.f_93618_ - 8, this.f_93619_ - 8, 0.0f, 0.0f, 16, 16, 16, 16);
                break;
            }
            case ENABLED: {
                pGuiGraphics.m_280411_(ICONS_LOCATION, this.m_252754_() + 4, this.m_252907_() + 4, this.f_93618_ - 8, this.f_93619_ - 8, 0.0f, 154.0f, 9, 8, 256, 256);
                break;
            }
            case PULL: {
                pGuiGraphics.m_280411_(ICONS_LOCATION, this.m_252754_() + 4, this.m_252907_() + 4, this.f_93618_ - 8, this.f_93619_ - 8, 9.0f, 154.0f, 9, 9, 256, 256);
                break;
            }
            case PUSH: {
                pGuiGraphics.m_280411_(ICONS_LOCATION, this.m_252754_() + 4, this.m_252907_() + 4, this.f_93618_ - 8, this.f_93619_ - 8, 9.0f, 145.0f, 9, 9, 256, 256);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected mode: " + this.getCurrentMode()));
            }
        }
        if (this.f_93622_) {
            this.parentScreen.setDrawnTooltip(this.tooltip);
        }
    }

    private Component getCurrentModeComponent() {
        return Component.m_237115_((String)"alchemistry.container.sides.current").m_7220_((Component)Component.m_237115_((String)("alchemistry.container.sides.mode." + this.getCurrentMode().name().toLowerCase(Locale.ROOT))));
    }

    public SideMode getCurrentMode() {
        return this.parentScreen.getInventory().getSideMode(this.side);
    }

    private void changeMode(int change) {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        int ordinal = (this.getCurrentMode().ordinal() + change) % 4;
        if (ordinal < 0) {
            ordinal = 3;
        }
        SideMode newMode = SideMode.getFromOrdinal((int)ordinal);
        this.parentScreen.getInventory().setSideMode(this.side, newMode);
        Alchemistry.PACKET_HANDLER.sendToServer(new SetSideConfigurationPacket(this.parentScreen.getBlockEntity().m_58899_(), this.parentScreen.getInventory().sideModesToShort()));
        this.tooltip.set(2, this.getCurrentModeComponent());
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.f_93623_ && this.f_93624_ && this.m_93680_(pMouseX, pMouseY)) {
            int delta;
            if (pButton == 0) {
                delta = -1;
            } else if (pButton == 1) {
                delta = 1;
            } else {
                return false;
            }
            this.changeMode(delta);
            return true;
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.f_93623_ && this.f_93624_ && (pKeyCode == 257 || pKeyCode == 335 || pKeyCode == 32)) {
            this.changeMode(1);
            return true;
        }
        return false;
    }
}

