/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.assembly;

import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.item.AssemblyProgramItem;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public abstract class AssemblyProgram {
    public EnumAssemblyProblem curProblem = EnumAssemblyProblem.NO_PROBLEM;

    public AssemblyRecipe.AssemblyProgramType getType() {
        return this.getItem().getProgramType();
    }

    public abstract EnumMachine[] getRequiredMachines();

    public abstract boolean executeStep(AssemblyControllerBlockEntity.AssemblySystem var1);

    public abstract boolean validateBlockEntity(AssemblyControllerBlockEntity.AssemblySystem var1);

    public abstract void writeToNBT(CompoundTag var1);

    public abstract void readFromNBT(CompoundTag var1);

    public abstract Collection<AssemblyRecipe> getRecipeList(Level var1);

    public void addProgramProblem(List<Component> problemList) {
        switch (this.curProblem) {
            case NO_INPUT: {
                problemList.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "The input IO Unit can't find an inventory with a Block of Compressed Iron.")));
                problemList.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.BLACK) + "Place an inventory with a Block of Compressed Iron surrounding the IO Unit.")));
                break;
            }
            case NO_OUTPUT: {
                problemList.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.GRAY) + "The output IO Unit can't find an inventory to place the output in.")));
                problemList.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.BLACK) + "Place an inventory / make space in a connected inventory.")));
            }
        }
    }

    static boolean isValidInput(AssemblyRecipe recipe, ItemStack input) {
        return recipe.matches(input);
    }

    public static AssemblyProgram fromRecipe(AssemblyRecipe recipe) {
        return AssemblyProgramItem.fromProgramType(recipe.getProgramType()).getProgram();
    }

    public abstract AssemblyProgramItem getItem();

    public static enum EnumAssemblyProblem {
        NO_PROBLEM,
        NO_INPUT,
        NO_OUTPUT;

    }

    public static enum EnumMachine implements ITranslatableEnum
    {
        PLATFORM(ModBlocks.ASSEMBLY_PLATFORM),
        DRILL(ModBlocks.ASSEMBLY_DRILL),
        LASER(ModBlocks.ASSEMBLY_LASER),
        IO_UNIT_EXPORT(ModBlocks.ASSEMBLY_IO_UNIT_EXPORT),
        IO_UNIT_IMPORT(ModBlocks.ASSEMBLY_IO_UNIT_IMPORT),
        CONTROLLER(ModBlocks.ASSEMBLY_CONTROLLER);

        private final RegistryObject<? extends Block> blockSupplier;

        private EnumMachine(RegistryObject<? extends Block> blockSupplier) {
            this.blockSupplier = blockSupplier;
        }

        public Block getMachineBlock() {
            return (Block)this.blockSupplier.get();
        }

        @Override
        public String getTranslationKey() {
            return this.getMachineBlock().m_7705_();
        }
    }
}

