/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IRedstoneEmissionWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import org.apache.commons.lang3.math.NumberUtils;

public class ProgWidgetEmitRedstone
extends ProgWidget
implements IRedstoneEmissionWidget,
ISidedWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};

    public ProgWidgetEmitRedstone() {
        super((ProgWidgetType)ModProgWidgets.EMIT_REDSTONE.get());
    }

    @Override
    public int getEmittingRedstone() {
        if (this.getConnectedParameters()[0] != null) {
            return NumberUtils.toInt((String)((ProgWidgetText)this.getConnectedParameters()[0]).string);
        }
        return 0;
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.noSideActive", new Object[0]));
        }
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.affectingSides", new Object[0]));
        curTooltip.addAll(this.getExtraStringInfo());
    }

    @Override
    public List<Component> getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return Collections.singletonList(ALL_TEXT);
        }
        if (noSides) {
            return Collections.singletonList(NONE_TEXT);
        }
        List<String> l = Arrays.stream(DirectionUtil.VALUES).filter(side -> this.accessingSides[side.m_122411_()]).map(ClientUtils::translateDirection).toList();
        return Collections.singletonList(Component.m_237113_((String)Strings.join(l, (String)", ")));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            tag.m_128379_(Direction.m_122376_((int)i).name(), true);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.m_128471_(Direction.m_122376_((int)i).name());
        }
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        for (int i = 0; i < 6; ++i) {
            buf.writeBoolean(this.accessingSides[i]);
        }
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = buf.readBoolean();
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((ProgWidgetType)ModProgWidgets.TEXT.get()));
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.RED;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EMIT_REDSTONE;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIEmitRedstone(drone, widget);
    }

    private static class DroneAIEmitRedstone
    extends Goal {
        private final IProgWidget widget;
        private final IDroneBase drone;

        DroneAIEmitRedstone(IDroneBase drone, IProgWidget widget) {
            this.widget = widget;
            this.drone = drone;
        }

        public boolean m_8036_() {
            boolean[] sides = ((ISidedWidget)((Object)this.widget)).getSides();
            for (int i = 0; i < 6; ++i) {
                if (!sides[i]) continue;
                this.drone.setEmittingRedstone(Direction.m_122376_((int)i), ((IRedstoneEmissionWidget)((Object)this.widget)).getEmittingRedstone());
            }
            return false;
        }
    }
}

