/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.RenderFluidTank;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.IBlockComparatorSupport;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractFluidTankBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.FluidItemWrapper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.IFluidRendered;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.RayTraceUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTankBlock
extends AbstractPneumaticCraftBlock
implements PneumaticCraftEntityBlock,
IBlockComparatorSupport {
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)15.0, (double)1.0), Block.m_49796_((double)2.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0, (double)16.0), Block.m_49796_((double)2.0, (double)14.0, (double)15.0, (double)14.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)14.0), Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)15.0, (double)14.0), Block.m_49796_((double)15.0, (double)1.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0), Block.m_49796_((double)15.0, (double)14.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)14.0), Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)3.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)2.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0), Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)3.0, (double)16.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private final Size size;

    public FluidTankBlock(Size size) {
        super(ModBlocks.defaultProps());
        this.size = size;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP, DOWN});
    }

    public Size getSize() {
        return this.size;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        return state == null ? null : (BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState up = worldIn.m_8055_(currentPos.m_7494_());
        if (((Boolean)stateIn.m_61143_((Property)UP)).booleanValue() && !(up.m_60734_() instanceof FluidTankBlock)) {
            stateIn = (BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(false));
        }
        BlockState down = worldIn.m_8055_(currentPos.m_7495_());
        if (((Boolean)stateIn.m_61143_((Property)DOWN)).booleanValue() && !(down.m_60734_() instanceof FluidTankBlock)) {
            stateIn = (BlockState)stateIn.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false));
        }
        return stateIn;
    }

    @Override
    public boolean onWrenched(Level world, Player player, BlockPos pos, Direction side, InteractionHand hand) {
        if (!player.m_6144_()) {
            AbstractFluidTankBlockEntity te;
            BlockHitResult brtr;
            HitResult rtr = RayTraceUtils.getMouseOverServer((LivingEntity)player, PneumaticCraftUtils.getPlayerReachDistance(player));
            if (rtr.m_6662_() == HitResult.Type.BLOCK && (brtr = (BlockHitResult)rtr).m_82425_().equals((Object)pos) && (te = this.getTankAt(world, pos)) != null) {
                double y = brtr.m_82450_().f_82480_ - (double)((int)brtr.m_82450_().f_82480_);
                return this.tryToggleConnection(te, y >= 0.5 ? Direction.UP : Direction.DOWN);
            }
            return false;
        }
        return super.onWrenched(world, player, pos, side, hand);
    }

    private boolean tryToggleConnection(AbstractFluidTankBlockEntity thisTank, Direction dir) {
        BlockState state = thisTank.m_58900_();
        Level level = thisTank.nonNullLevel();
        AbstractFluidTankBlockEntity neighbourTank = this.getTankAt(level, thisTank.m_58899_().m_121945_(dir));
        if (neighbourTank == null) {
            return false;
        }
        BlockState stateOther = neighbourTank.m_58900_();
        boolean isConnected = (Boolean)state.m_61143_((Property)FluidTankBlock.connectionProperty(dir));
        if (isConnected) {
            level.m_46597_(thisTank.m_58899_(), (BlockState)state.m_61124_((Property)FluidTankBlock.connectionProperty(dir), (Comparable)Boolean.valueOf(false)));
            level.m_46597_(neighbourTank.m_58899_(), (BlockState)stateOther.m_61124_((Property)FluidTankBlock.connectionProperty(dir.m_122424_()), (Comparable)Boolean.valueOf(false)));
            return true;
        }
        FluidStack stack = thisTank.getTank().getFluid();
        if (neighbourTank.isFluidCompatible(stack, neighbourTank.getTank()) && neighbourTank.isNeighbourCompatible(stack, dir)) {
            level.m_46597_(thisTank.m_58899_(), (BlockState)state.m_61124_((Property)FluidTankBlock.connectionProperty(dir), (Comparable)Boolean.valueOf(true)));
            level.m_46597_(neighbourTank.m_58899_(), (BlockState)stateOther.m_61124_((Property)FluidTankBlock.connectionProperty(dir.m_122424_()), (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return false;
    }

    private AbstractFluidTankBlockEntity getTankAt(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof AbstractFluidTankBlockEntity ? (AbstractFluidTankBlockEntity)te : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return this.size.beFactory.apply(pPos, pState);
    }

    public static enum Size {
        SMALL(32000, AbstractFluidTankBlockEntity.Small::new),
        MEDIUM(64000, AbstractFluidTankBlockEntity.Medium::new),
        LARGE(128000, AbstractFluidTankBlockEntity.Large::new),
        HUGE(512000, AbstractFluidTankBlockEntity.Huge::new);

        private final int capacity;
        private final BiFunction<BlockPos, BlockState, BlockEntity> beFactory;

        private Size(int capacity, BiFunction<BlockPos, BlockState, BlockEntity> beFactory) {
            this.capacity = capacity;
            this.beFactory = beFactory;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    public static class ItemBlockFluidTank
    extends BlockItem
    implements IFluidRendered {
        public static final String TANK_NAME = "Tank";
        private final int capacity;
        private RenderFluidTank.ItemRenderInfoProvider renderInfoProvider;

        public ItemBlockFluidTank(Block block) {
            super(block, ModItems.defaultProps());
            this.capacity = ((FluidTankBlock)block).size.capacity;
        }

        public boolean hasCraftingRemainingItem(ItemStack stack) {
            return FluidUtil.getFluidContained((ItemStack)stack).map(f -> !f.isEmpty()).orElse(false);
        }

        public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
            boolean creative = UpgradableItemUtils.hasCreativeUpgrade(itemStack);
            return (ItemStack)FluidUtil.getFluidHandler((ItemStack)itemStack.m_41777_()).map(handler -> {
                handler.drain(1000, creative ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
                return handler.getContainer();
            }).orElseThrow(RuntimeException::new);
        }

        @Override
        public IFluidItemRenderInfoProvider getFluidItemRenderer() {
            if (this.renderInfoProvider == null) {
                this.renderInfoProvider = new RenderFluidTank.ItemRenderInfoProvider();
            }
            return this.renderInfoProvider;
        }

        public int getMaxStackSize(ItemStack stack) {
            return stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("BlockEntityTag") ? 1 : 64;
        }

        @Nullable
        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
            if (stack.m_41720_() instanceof ItemBlockFluidTank) {
                return new FluidItemWrapper(stack, TANK_NAME, this.capacity);
            }
            return super.initCapabilities(stack, nbt);
        }
    }
}

