/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.upgrade.PNCUpgrade;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.OmnidirectionalHopperBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.OmnidirectionalHopperMenu;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class OmnidirectionalHopperScreen
extends AbstractPneumaticCraftContainerScreen<OmnidirectionalHopperMenu, OmnidirectionalHopperBlockEntity> {
    private static final Component ARROW_NO_RR = Component.m_237113_((String)"\u27f6");
    private static final Component ARROW_RR = Component.m_237113_((String)"\u293e").m_130940_(ChatFormatting.GREEN);
    private WidgetAnimatedStat statusStat;
    private final WidgetButtonExtended[] modeButtons = new WidgetButtonExtended[2];
    private WidgetButtonExtended rrButton;

    public OmnidirectionalHopperScreen(OmnidirectionalHopperMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.hopperStatus", new Object[0]), new ItemStack((ItemLike)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -22016, false);
        WidgetAnimatedStat optionStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.gasLift.mode", new Object[0]), new ItemStack((ItemLike)Blocks.f_50164_), -13312, false);
        optionStat.setMinimumExpandedDimensions(50, 43);
        WidgetButtonExtended button = new WidgetButtonExtended(5, 20, 20, 20, (Component)Component.m_237119_()).withTag("empty");
        button.setRenderStacks(new ItemStack((ItemLike)Items.f_42446_));
        button.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.omnidirectionalHopper.mode.empty", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[0] = button;
        button = new WidgetButtonExtended(30, 20, 20, 20, (Component)Component.m_237119_()).withTag("leave");
        button.setRenderStacks(new ItemStack((ItemLike)Items.f_42447_));
        button.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.omnidirectionalHopper.mode.leaveItem", new Object[0])));
        optionStat.addSubWidget((AbstractWidget)button);
        this.modeButtons[1] = button;
        this.rrButton = new WidgetButtonExtended(this.f_97735_ + 143, this.f_97736_ + 55, 14, 14, (Component)Component.m_237119_()).withTag("rr");
        this.m_142416_((GuiEventListener)this.rrButton);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_OMNIDIRECTIONAL_HOPPER;
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.statusStat.setText(this.getStatus());
        this.modeButtons[0].f_93623_ = ((OmnidirectionalHopperBlockEntity)this.te).doesLeaveMaterial();
        this.modeButtons[1].f_93623_ = !((OmnidirectionalHopperBlockEntity)this.te).doesLeaveMaterial();
        this.rrButton.m_93666_(((OmnidirectionalHopperBlockEntity)this.te).roundRobin ? ARROW_RR : ARROW_NO_RR);
        this.rrButton.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.omnidirectional_hopper.roundRobin." + (((OmnidirectionalHopperBlockEntity)this.te).roundRobin ? "on" : "off"), new Object[0])));
    }

    private List<Component> getStatus() {
        ArrayList<Component> textList = new ArrayList<Component>();
        int itemsPer = ((OmnidirectionalHopperBlockEntity)this.te).getMaxItems();
        if (itemsPer > 1) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.itemTransferPerTick", itemsPer));
        } else {
            int transferInterval = ((OmnidirectionalHopperBlockEntity)this.te).getItemTransferInterval();
            String s = transferInterval == 0 ? "20" : PneumaticCraftUtils.roundNumberTo(20.0f / (float)transferInterval, 1);
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.hopperStatus.itemTransferPerSecond", s));
        }
        return textList;
    }

    @Override
    protected boolean isUpgradeAvailable(PNCUpgrade upgrade) {
        return upgrade != ModUpgrades.DISPENSER.get() || (Boolean)ConfigHelper.common().machines.omniHopperDispenser.get() != false;
    }
}

