/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.PneumaticCraftBucketItem;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ColorHandlers {
    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            Object object = item.get();
            if (object instanceof ITintableItem) {
                ITintableItem tintable = (ITintableItem)object;
                event.register(tintable::getTintColor, new ItemLike[]{(ItemLike)item.get()});
                continue;
            }
            object = item.get();
            if (object instanceof BlockItem) {
                BlockItem bi = (BlockItem)object;
                Block b = bi.m_40614_();
                if (!(b instanceof ITintableBlock)) continue;
                event.register((stack, index) -> event.getBlockColors().m_92577_(b.m_49966_(), null, null, index), new ItemLike[]{(ItemLike)item.get()});
                continue;
            }
            if (!(item.get() instanceof PneumaticCraftBucketItem)) continue;
            event.register((ItemColor)new DynamicFluidContainerModel.Colors(), new ItemLike[]{(ItemLike)item.get()});
        }
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (RegistryObject block : ModBlocks.BLOCKS.getEntries()) {
            Object object = block.get();
            if (object instanceof ITintableBlock) {
                ITintableBlock tintable = (ITintableBlock)object;
                event.register(tintable::getTintColor, new Block[]{(Block)block.get()});
                continue;
            }
            if (!(block.get() instanceof AbstractCamouflageBlock)) continue;
            event.register((state, level, pos, tintIndex) -> {
                CamouflageableBlockEntity camo;
                BlockEntity te;
                if (level != null && pos != null && (te = level.m_7702_(pos)) instanceof CamouflageableBlockEntity && (camo = (CamouflageableBlockEntity)te).getCamouflage() != null) {
                    return event.getBlockColors().m_92577_(camo.getCamouflage(), (BlockAndTintGetter)te.m_58904_(), pos, tintIndex);
                }
                return -1;
            }, new Block[]{(Block)block.get()});
        }
    }

    public static int desaturate(int c) {
        float[] hsb = TintColor.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        TintColor color = TintColor.getHSBColor(hsb[0], hsb[1] * 0.4f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }

    public static interface ITintableItem {
        public int getTintColor(ItemStack var1, int var2);
    }

    public static interface ITintableBlock {
        public int getTintColor(BlockState var1, @Nullable BlockAndTintGetter var2, @Nullable BlockPos var3, int var4);
    }

    public static interface IHeatTintable
    extends ITintableBlock {
        @Override
        default public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
            if (world != null && pos != null) {
                BlockEntity te = world.m_7702_(pos);
                TintColor tint = te instanceof IHeatTinted ? ((IHeatTinted)te).getColorForTintIndex(tintIndex) : TintColor.WHITE;
                return tint.getRGB();
            }
            return -1;
        }
    }
}

