/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.mixins.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixins.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.utils.BoxOctree;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.LegacyOceanBottomSinglePoolElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static Optional<Structure.GenerationStub> assembleJigsawStructure(Structure.GenerationContext context, Holder<StructureTemplatePool> startPoolHolder, int size, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, Optional<Heightmap.Types> heightmapType, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster) {
        Registry jigsawPoolRegistry = context.f_226621_().m_175515_(Registries.f_256948_);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        Rotation rotation = Rotation.m_221990_((RandomSource)random);
        StructureTemplatePool startPool = (StructureTemplatePool)startPoolHolder.m_203334_();
        if (startPool.m_210590_() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
            throw new RuntimeException("Repurposed Structures: Empty or nonexistent start pool in structure: " + structureID + " Crash is imminent");
        }
        StructurePoolElement startPieceBlueprint = startPool.m_227355_((RandomSource)random);
        if (startPieceBlueprint == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.f_226625_(), startPieceBlueprint, startPos, startPieceBlueprint.m_210540_(), rotation, startPieceBlueprint.m_214015_(context.f_226625_(), startPos, rotation));
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int pieceCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int pieceCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int pieceCenterY = heightmapType.map(types -> startPos.m_123342_() + context.f_226622_().m_223221_(pieceCenterX, pieceCenterZ, types, context.f_226629_(), context.f_226624_())).orElseGet(() -> ((BlockPos)startPos).m_123342_());
        if (heightmapType.isPresent() && (pieceCenterY > maxY || pieceCenterY < minY)) {
            return Optional.empty();
        }
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, pieceCenterY - yAdjustment, 0);
        if (!context.f_226630_().test(context.f_226622_().m_62218_().m_203407_(QuartPos.m_175400_((int)pieceCenterX), QuartPos.m_175400_((int)pieceCenterY), QuartPos.m_175400_((int)pieceCenterZ), context.f_226624_().m_224579_()))) {
            return Optional.empty();
        }
        return Optional.of(new Structure.GenerationStub(new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ), structurePiecesBuilder -> {
            ArrayList<PoolElementStructurePiece> components = new ArrayList<PoolElementStructurePiece>();
            components.add(startPiece);
            Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces = StructurePieceCountsManager.STRUCTURE_PIECE_COUNTS_MANAGER.getRequirePieces(structureID);
            boolean runOnce = requiredPieces == null || requiredPieces.isEmpty();
            HashMap<ResourceLocation, Integer> currentPieceCounter = new HashMap<ResourceLocation, Integer>();
            int attempts = 0;
            while (runOnce || PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces, currentPieceCounter)) {
                if (attempts == 40) {
                    RepurposedStructures.LOGGER.error("\n-------------------------------------------------------------------\nRepurposed Structures: Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces failed to generate the required amount are: {}\n  This can happen if a structure has a required piece but the structure size is set too low.\n  However, this is most likely caused by a structure unable to spawn properly due to hitting the world's min y or max y build thresholds or a broken RS datapack.\n  Try teleporting to: {} and see if the structure generated fine with the required structure piece or if it is indeed missing it.\n  Please report the issue to Repurposed Structures's dev with latest.log file if the structure is not cut off by world min/max y build thresholds.\n\n", (Object)jigsawPoolRegistry.m_7981_((Object)startPool), (Object)Arrays.toString(currentPieceCounter.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).toArray()), (Object)new BlockPos(pieceCenterX, pieceCenterY, pieceCenterZ));
                    break;
                }
                PoolElementStructurePiece startPieceToUse = startPiece;
                if (attempts > 0) {
                    StructurePoolElement startPieceBlueprintNew = startPool.m_227355_((RandomSource)random);
                    startPieceToUse = new PoolElementStructurePiece(context.f_226625_(), startPieceBlueprintNew, startPiece.m_72646_(), startPieceBlueprintNew.m_210540_(), startPiece.m_6830_(), startPieceBlueprintNew.m_214015_(context.f_226625_(), startPiece.m_72646_(), startPiece.m_6830_()));
                }
                components.clear();
                components.add(startPieceToUse);
                if (size > 0) {
                    int boxRange = maxDistanceFromCenter.orElse(80);
                    AABB axisAlignedBB = new AABB((double)(pieceCenterX - boxRange), (double)(pieceCenterY - 120), (double)(pieceCenterZ - boxRange), (double)(pieceCenterX + boxRange + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + boxRange + 1));
                    BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                    boxOctree.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
                    Entry startPieceEntry = new Entry(startPieceToUse, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), pieceCenterY + 80, 0);
                    Assembler assembler = new Assembler(structureID, (Registry<StructureTemplatePool>)jigsawPoolRegistry, size, context, components, (RandomSource)random, requiredPieces, buryingType.isEmpty() ? maxY : Integer.MAX_VALUE, buryingType.isEmpty() ? minY : Integer.MIN_VALUE, poolsThatIgnoreBounds);
                    assembler.availablePieces.addLast(startPieceEntry);
                    while (!assembler.availablePieces.isEmpty()) {
                        Entry entry2 = assembler.availablePieces.removeFirst();
                        assembler.generatePiece(entry2.piece, entry2.boxOctreeMutableObject, entry2.topYLimit, entry2.depth, doBoundaryAdjustments, context.f_226629_());
                    }
                }
                if (runOnce) break;
                ++attempts;
            }
            components.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
            structureBoundsAdjuster.accept((StructurePiecesBuilder)structurePiecesBuilder, (List<PoolElementStructurePiece>)components);
            if (structurePiecesBuilder.m_192798_().m_162400_() > context.f_226629_().m_151558_()) {
                structurePiecesBuilder.m_192796_();
            }
        }));
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? extends StructurePiece> components, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, Map<ResourceLocation, Integer> counter) {
        counter.clear();
        requiredPieces.forEach((key, value) -> counter.put((ResourceLocation)key, value.getRequiredAmount()));
        for (StructurePiece structurePiece : components) {
            ResourceLocation pieceID;
            StructurePoolElement poolElement;
            if (!(structurePiece instanceof PoolElementStructurePiece) || !((poolElement = ((PoolElementStructurePiece)structurePiece).m_209918_()) instanceof SinglePoolElement) || !counter.containsKey(pieceID = (ResourceLocation)((SinglePoolElementAccessor)poolElement).repurposedstructures_getTemplate().left().orElse(null))) continue;
            counter.put(pieceID, counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public record Entry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final Structure.GenerationContext context;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final RandomSource random;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<ResourceLocation, Integer> currentPieceCounts;
        private final Map<ResourceLocation, Integer> maximumPieceCounts;
        private final Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;
        private final Set<ResourceLocation> poolsThatIgnoreBounds;

        public Assembler(ResourceLocation structureID, Registry<StructureTemplatePool> poolRegistry, int maxDepth, Structure.GenerationContext context, List<? super PoolElementStructurePiece> structurePieces, RandomSource random, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.context = context;
            this.structurePieces = structurePieces;
            this.random = random;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = requiredPieces == null ? new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>() : new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>(requiredPieces);
            this.maximumPieceCounts = new HashMap<ResourceLocation, Integer>(StructurePieceCountsManager.STRUCTURE_PIECE_COUNTS_MANAGER.getMaximumCountForPieces(structureID));
            this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
            this.currentPieceCounts = new HashMap<ResourceLocation, Integer>();
            this.requiredPieces.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
            this.maximumPieceCounts.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
        }

        public void generatePiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor heightLimitView) {
            StructurePoolElement pieceBlueprint = piece.m_209918_();
            BlockPos piecePos = piece.m_72646_();
            Rotation pieceRotation = piece.m_6830_();
            BoundingBox pieceBoundingBox = piece.m_73547_();
            int pieceMinY = pieceBoundingBox.m_162396_();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.m_213638_(this.context.f_226625_(), piecePos, pieceRotation, this.random);
            for (StructureTemplate.StructureBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_());
                BlockPos jigsawBlockPos = jigsawBlock.f_74675_();
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.m_121945_(direction);
                ResourceLocation jigsawBlockPool = new ResourceLocation(jigsawBlock.f_74677_().m_128461_("pool"));
                Optional poolOptional = this.poolRegistry.m_6612_(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).m_210590_() == 0 && !Objects.equals(jigsawBlockPool, Pools.f_127186_.m_135782_())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                Holder jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).m_254935_();
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.m_82321_((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)poolOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, false)) != null) continue;
                boolean ignoreBounds = false;
                if (this.poolsThatIgnoreBounds != null) {
                    ResourceLocation fallBackPoolRL = this.poolRegistry.m_7981_((Object)((StructureTemplatePool)jigsawBlockFallback.m_203334_()));
                    ignoreBounds = this.poolsThatIgnoreBounds.contains(fallBackPoolRL);
                }
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)jigsawBlockFallback.m_203334_()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, ignoreBounds);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, PoolElementStructurePiece piece, int depth, int targetPieceBoundsTop, LevelHeightAccessor heightLimitView, boolean ignoreBounds) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.m_209918_().m_210539_();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            boolean isPieceOceanFloor = piece.m_209918_() instanceof LegacyOceanBottomSinglePoolElement;
            int jigsawBlockRelativeY = jigsawBlockPos.m_123342_() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                StructurePoolElement candidatePiece;
                Object chosenPiecePair = null;
                Optional<ResourceLocation> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.currentPieceCounts.get(key);
                    StructurePieceCountsManager.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    return currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<StructurePoolElement, Integer> candidatePiecePair = candidatePieces.get(i);
                        StructurePoolElement structurePoolElement = (StructurePoolElement)candidatePiecePair.getFirst();
                        if (!(structurePoolElement instanceof SinglePoolElement) || !((ResourceLocation)((SinglePoolElementAccessor)structurePoolElement).repurposedstructures_getTemplate().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= Math.min(this.maxDepth - 1, this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter())) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.random.m_188503_(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.f_210175_) {
                    return null;
                }
                ResourceLocation pieceName = null;
                if (candidatePiece instanceof SinglePoolElement && this.currentPieceCounts.containsKey(pieceName = (ResourceLocation)((SinglePoolElementAccessor)candidatePiece).repurposedstructures_getTemplate().left().get()) && this.maximumPieceCounts.containsKey(pieceName) && this.currentPieceCounts.get(pieceName) >= this.maximumPieceCounts.get(pieceName)) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.m_221992_((RandomSource)this.random)) {
                    List candidateJigsawBlocks = candidatePiece.m_213638_(this.context.f_226625_(), BlockPos.f_121853_, rotation, this.random);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.m_214015_(this.context.f_226625_(), BlockPos.f_121853_, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.m_71057_() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_())))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_().m_128461_("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.m_6612_(candidateTargetPool);
                        if (candidateTargetPoolOptional.isEmpty()) {
                            RepurposedStructures.LOGGER.warn("Repurposed Structures: Non-existent child pool attempted to be spawned: {} which is being called from {}. Let Repurposed Structures dev (TelepathicGrunt) know about this log entry.", (Object)candidateTargetPool, candidatePiece instanceof SinglePoolElement ? ((SinglePoolElementAccessor)candidatePiece).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                        }
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetPoolOptional.map(c -> ((StructureTemplatePool)c.m_254935_().m_203334_()).m_227357_(this.context.f_226625_())).orElse(0);
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(c -> c.m_227357_(this.context.f_226625_())).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_();
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.m_123341_() - candidateJigsawBlockPos.m_123341_(), jigsawBlockTargetPos.m_123342_() - candidateJigsawBlockPos.m_123342_(), jigsawBlockTargetPos.m_123343_() - candidateJigsawBlockPos.m_123343_());
                        BoundingBox candidateBoundingBox = candidatePiece.m_214015_(this.context.f_226625_(), candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.m_210539_();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        boolean isCandidatePieceOceanFloor = candidatePiece instanceof LegacyOceanBottomSinglePoolElement;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_()).m_122430_();
                        if (isPieceRigid && !isPieceOceanFloor && isCandidateRigid && !isCandidatePieceOceanFloor) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.context.f_226622_().m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), isCandidatePieceOceanFloor || isPieceOceanFloor ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.context.f_226624_());
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.m_162396_();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_7918_(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                            adjustedCandidateBoundingBox.m_162371_(new BlockPos(adjustedCandidateBoundingBox.m_162395_(), adjustedCandidateBoundingBox.m_162396_() + k2, adjustedCandidateBoundingBox.m_162398_()));
                        }
                        if (adjustedCandidateBoundingBox.m_162400_() > this.maxY || adjustedCandidateBoundingBox.m_162396_() < this.minY) continue;
                        AABB axisAlignedBB = AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox);
                        AABB axisAlignedBBDeflated = axisAlignedBB.m_82406_(0.25);
                        boolean validBounds = false;
                        if (ignoreBounds || ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!validBounds) continue;
                        int newPieceGroundLevelDelta = piece.m_72647_();
                        int groundLevelDelta = isCandidateRigid && !isCandidatePieceOceanFloor ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.m_210540_();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.context.f_226625_(), candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid && !isPieceOceanFloor) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid && !isCandidatePieceOceanFloor) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.context.f_226622_().m_223221_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), isCandidatePieceOceanFloor || isPieceOceanFloor ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, this.context.f_226624_());
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.m_209916_(new JigsawJunction(jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.m_209916_(new JigsawJunction(jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.currentPieceCounts.containsKey(pieceName)) {
                            this.currentPieceCounts.put(pieceName, this.currentPieceCounts.get(pieceName) + 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

