/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;

public class CloseOffAirSourcesProcessor
extends StructureProcessor {
    public static final Codec<CloseOffAirSourcesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.mapPair((MapCodec)BuiltInRegistries.f_256975_.m_194605_().fieldOf("block"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("weighted_list_of_replacement_blocks").forGetter(processor -> processor.weightedReplacementBlocks)).apply((Applicative)instance, instance.stable(CloseOffAirSourcesProcessor::new)));
    private final List<Pair<Block, Integer>> weightedReplacementBlocks;

    public CloseOffAirSourcesProcessor(List<Pair<Block, Integer>> weightedReplacementBlocks) {
        this.weightedReplacementBlocks = weightedReplacementBlocks;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo infoIn2, StructurePlaceSettings settings) {
        WorldGenRegion worldGenRegion;
        ChunkPos currentChunkPos = new ChunkPos(infoIn2.f_74675_());
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).m_143488_().equals((Object)currentChunkPos)) {
            return infoIn2;
        }
        if (!infoIn2.f_74676_().m_60819_().m_76178_()) {
            ChunkAccess currentChunk = levelReader.m_6325_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
            Fluid currentFluid = infoIn2.f_74676_().m_60819_().m_76152_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                Block replacementBlock;
                BlockState neighboringState;
                int sectionYIndex;
                LevelChunkSection levelChunkSection;
                mutable.m_122190_((Vec3i)infoIn2.f_74675_()).m_122173_(direction);
                if (mutable.m_123342_() < currentChunk.m_141937_() || mutable.m_123342_() >= currentChunk.m_151558_()) continue;
                if (currentChunkPos.f_45578_ != mutable.m_123341_() >> 4 || currentChunkPos.f_45579_ != mutable.m_123343_() >> 4) {
                    currentChunk = levelReader.m_46865_((BlockPos)mutable);
                    currentChunkPos = new ChunkPos((BlockPos)mutable);
                }
                LevelHeightAccessor levelHeightAccessor = currentChunk.m_183618_();
                if (!(levelReader instanceof WorldGenLevel) || mutable.m_123342_() < levelHeightAccessor.m_141937_() || mutable.m_123342_() >= levelHeightAccessor.m_151558_() || (levelChunkSection = currentChunk.m_183278_(sectionYIndex = currentChunk.m_151564_(mutable.m_123342_()))) == null || !(neighboringState = levelChunkSection.m_62982_(SectionPos.m_123207_((int)mutable.m_123341_()), SectionPos.m_123207_((int)mutable.m_123342_()), SectionPos.m_123207_((int)mutable.m_123343_()))).m_60795_() && (!(neighboringState.m_60734_() instanceof LiquidBlock) || currentFluid.equals(neighboringState.m_60819_().m_76152_()))) continue;
                if (this.weightedReplacementBlocks.size() == 1) {
                    replacementBlock = (Block)this.weightedReplacementBlocks.get(0).getFirst();
                } else {
                    RandomSource random = settings.m_230326_(infoIn2.f_74675_());
                    replacementBlock = (Block)GeneralUtils.getRandomEntry(this.weightedReplacementBlocks, random);
                }
                levelChunkSection.m_62991_(SectionPos.m_123207_((int)mutable.m_123341_()), SectionPos.m_123207_((int)mutable.m_123342_()), SectionPos.m_123207_((int)mutable.m_123343_()), replacementBlock.m_49966_(), false);
            }
        }
        return infoIn2;
    }

    protected StructureProcessorType<?> m_6953_() {
        return RSProcessors.CLOSE_OFF_AIR_SOURCES_PROCESSOR.get();
    }
}

