/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ProductiveDrippyFruitBlock
extends ProductiveFruitBlock {
    private final Supplier<Block> puddle;

    public ProductiveDrippyFruitBlock(BlockBehaviour.Properties properties, TreeObject treeObject, Supplier<Block> puddle) {
        super(properties, treeObject);
        this.puddle = puddle;
    }

    @Override
    public boolean m_6724_(BlockState blockState) {
        return true;
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.m_213898_(state, level, blockPos, random);
        if (this.getAge(state) == ProductiveDrippyFruitBlock.getMaxAge()) {
            BlockState puddle = this.puddle.get().m_49966_();
            int n = 0;
            BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            while (n++ < 20 && level.m_8055_(pointer.m_7495_()).m_247087_() && !level.m_8055_(pointer.m_7495_()).m_60713_(puddle.m_60734_())) {
                pointer.m_122173_(Direction.DOWN);
            }
            BlockState stateBelow = level.m_8055_(pointer.m_7495_());
            if (stateBelow.m_60713_(puddle.m_60734_())) {
                int layers = Math.min(8, (Integer)stateBelow.m_61143_((Property)BlockStateProperties.f_61417_) + 1);
                if (layers > 3) {
                    for (Direction dir : Direction.values()) {
                        if (!dir.m_122434_().m_122479_() || !level.m_8055_(pointer.m_7495_().m_121945_(dir)).m_247087_() || !level.m_8055_(pointer.m_6625_(2).m_121945_(dir)).m_60783_((BlockGetter)level, pointer.m_6625_(2).m_121945_(dir), Direction.UP)) continue;
                        level.m_46597_(pointer.m_7495_().m_121945_(dir), puddle);
                    }
                    level.m_46597_(pointer.m_7495_(), (BlockState)puddle.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(1)));
                } else {
                    level.m_46597_(pointer.m_7495_(), (BlockState)puddle.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layers)));
                }
            } else if (stateBelow.m_60783_((BlockGetter)level, pointer.m_7495_(), Direction.UP)) {
                level.m_46597_((BlockPos)pointer, puddle);
            }
            level.m_7731_(blockPos, this.getStateForAge(state, 0), 2);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return InteractionResult.SUCCESS;
    }
}

