/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class IncubationRecipe
implements Recipe<Container>,
TimedRecipeInterface {
    public final ResourceLocation id;
    public final Ingredient input;
    public final Ingredient catalyst;
    public final Ingredient result;

    public IncubationRecipe(ResourceLocation id, Ingredient input, Ingredient catalyst, Ingredient result) {
        this.id = id;
        this.input = input;
        this.catalyst = catalyst;
        this.result = result;
    }

    @Override
    public int getProcessingTime() {
        return (Integer)ProductiveBeesConfig.GENERAL.incubatorProcessingTime.get();
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.INCUBATION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.INCUBATION_TYPE.get();
    }

    public static class Serializer<T extends IncubationRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"input")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            Ingredient catalyst = GsonHelper.m_13885_((JsonObject)json, (String)"catalyst") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"catalyst")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"catalyst"));
            Ingredient output = GsonHelper.m_13885_((JsonObject)json, (String)"output") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"output")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return this.factory.create(id, input, catalyst, output);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee incubation recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((IncubationRecipe)recipe).input.m_43923_(buffer);
                ((IncubationRecipe)recipe).catalyst.m_43923_(buffer);
                ((IncubationRecipe)recipe).result.m_43923_(buffer);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee incubation recipe to packet. " + ((IncubationRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends IncubationRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, Ingredient var4);
        }
    }
}

