/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.crafting.conditions;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BeeExistsCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("productivebees", "bee_exists");
    private final ResourceLocation beeName;

    public BeeExistsCondition(String location) {
        this(new ResourceLocation(location));
    }

    public BeeExistsCondition(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    public BeeExistsCondition(ResourceLocation tag) {
        this.beeName = tag;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        JsonObject beeData = BeeReloadListener.INSTANCE.getCondition(this.beeName.toString());
        return beeData != null && CraftingHelper.processConditions((JsonObject)beeData, (String)"conditions", (ICondition.IContext)context);
    }

    public String toString() {
        return "bee_exists(\"" + this.beeName + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<BeeExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, BeeExistsCondition value) {
            json.addProperty("bee", value.beeName.toString());
        }

        public BeeExistsCondition read(JsonObject json) {
            return new BeeExistsCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"bee")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

