/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CommandTPX {
    private static Random rand = new Random();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tpx").requires(p_198816_0_ -> p_198816_0_.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).m_81374_()), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), null, null))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).m_81374_()), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), null))))).then(Commands.m_82129_((String)"destination", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> CommandTPX.teleportToEntity((CommandSourceStack)ctx.getSource(), Collections.singleton(((CommandSourceStack)ctx.getSource()).m_81374_()), EntityArgument.m_91452_((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"destination", (ArgumentType)EntityArgument.m_91449_()).executes(ctx -> CommandTPX.teleportToEntity((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), EntityArgument.m_91452_((CommandContext)ctx, (String)"destination"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), new EntityLocation(((CommandSourceStack)ctx.getSource()).m_81374_()), null))).then(Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandTPX.teleportToPos((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), null))))));
    }

    private static int teleportToEntity(CommandSourceStack source, Collection<? extends Entity> targets, Entity destination) {
        for (Entity entity : targets) {
            CommandTPX.teleport(source, entity, (ServerLevel)destination.m_9236_(), destination.m_20185_(), destination.m_20186_(), destination.m_20189_(), EnumSet.noneOf(RelativeMovement.class), destination.m_146908_(), destination.m_146909_());
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.entity.single", (Object[])new Object[]{((Entity)targets.iterator().next()).m_5446_(), destination.m_5446_()}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.entity.multiple", (Object[])new Object[]{targets.size(), destination.m_5446_()}), true);
        }
        return targets.size();
    }

    private static int teleportToPos(CommandSourceStack source, Collection<? extends Entity> targets, ServerLevel targetWorld, @Nullable Coordinates position, @Nullable Coordinates rotationIn) throws CommandSyntaxException {
        if (position == null) {
            BlockPos pos = new BlockPos(0, 127, 0);
            rand.setSeed(0L);
            for (int i = 0; i < 1000; ++i) {
                pos = i < 500 ? new BlockPos(-150 + rand.nextInt(300), 32 + rand.nextInt(80), -150 + rand.nextInt(300)) : new BlockPos(-250 + rand.nextInt(500), 256, -250 + rand.nextInt(500));
                if (!targetWorld.m_46859_(pos)) continue;
                while (targetWorld.m_46859_(pos.m_7495_()) && targetWorld.m_46739_(pos.m_7495_())) {
                    pos = pos.m_7495_();
                }
                BlockState state = targetWorld.m_8055_(pos.m_7495_());
                if (state.m_60819_().m_76178_() && state.m_280555_()) break;
            }
            position = new BlockLocation(pos);
        }
        Vec3 vec3d = position.m_6955_(source);
        Vec2 vec2f = rotationIn == null ? null : rotationIn.m_6970_(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (position.m_6888_()) {
            set.add(RelativeMovement.X);
        }
        if (position.m_6892_()) {
            set.add(RelativeMovement.Y);
        }
        if (position.m_6900_()) {
            set.add(RelativeMovement.Z);
        }
        if (rotationIn == null) {
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
        } else {
            if (rotationIn.m_6888_()) {
                set.add(RelativeMovement.X_ROT);
            }
            if (rotationIn.m_6892_()) {
                set.add(RelativeMovement.Y_ROT);
            }
        }
        for (Entity entity : targets) {
            if (rotationIn == null) {
                CommandTPX.teleport(source, entity, targetWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, set, entity.m_146908_(), entity.m_146909_());
                continue;
            }
            CommandTPX.teleport(source, entity, targetWorld, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, set, vec2f.f_82471_, vec2f.f_82470_);
        }
        if (targets.size() == 1) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)targets.iterator().next()).m_5446_(), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_}), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_}), true);
        }
        return targets.size();
    }

    private static void teleport(CommandSourceStack source, Entity entityIn, ServerLevel worldIn, double x, double y, double z, Set<RelativeMovement> relativeList, float yaw, float pitch) {
        if (entityIn instanceof ServerPlayer) {
            ChunkPos chunkpos = new ChunkPos(BlockPos.m_274561_((double)x, (double)y, (double)z));
            worldIn.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entityIn.m_19879_());
            entityIn.m_8127_();
            if (((ServerPlayer)entityIn).m_5803_()) {
                ((ServerPlayer)entityIn).m_5796_();
            }
            if (worldIn == entityIn.m_9236_()) {
                ((ServerPlayer)entityIn).f_8906_.m_9780_(x, y, z, yaw, pitch, relativeList);
            } else {
                ((ServerPlayer)entityIn).m_8999_(worldIn, x, y, z, yaw, pitch);
            }
            entityIn.m_5616_(yaw);
        } else {
            float f1 = Mth.m_14177_((float)yaw);
            float f = Mth.m_14177_((float)pitch);
            f = Mth.m_14036_((float)f, (float)-90.0f, (float)90.0f);
            if (worldIn == entityIn.m_9236_()) {
                entityIn.m_7678_(x, y, z, f1, f);
                entityIn.m_5616_(f1);
            } else {
                entityIn.m_19877_();
                entityIn.m_5489_(worldIn);
                Entity entity = entityIn;
                entityIn = entityIn.m_6095_().m_20615_((Level)worldIn);
                if (entityIn == null) {
                    return;
                }
                entityIn.m_20361_(entity);
                entityIn.m_7678_(x, y, z, f1, f);
                entityIn.m_5616_(f1);
                worldIn.m_143334_(entityIn);
            }
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).m_21255_()) {
            entityIn.m_20256_(entityIn.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entityIn.m_6853_(true);
        }
    }

    private static class BlockLocation
    implements Coordinates {
        private BlockPos pos;

        public BlockLocation(BlockPos pos) {
            this.pos = pos;
        }

        public Vec3 m_6955_(CommandSourceStack source) {
            return Vec3.m_82512_((Vec3i)this.pos);
        }

        public Vec2 m_6970_(CommandSourceStack source) {
            return source.m_81376_();
        }

        public boolean m_6888_() {
            return false;
        }

        public boolean m_6892_() {
            return false;
        }

        public boolean m_6900_() {
            return false;
        }
    }

    private static class EntityLocation
    implements Coordinates {
        private Entity entity;

        public EntityLocation(Entity entity) {
            this.entity = entity;
        }

        public Vec3 m_6955_(CommandSourceStack source) {
            return this.entity.m_20182_();
        }

        public Vec2 m_6970_(CommandSourceStack source) {
            return source.m_81376_();
        }

        public boolean m_6888_() {
            return false;
        }

        public boolean m_6892_() {
            return false;
        }

        public boolean m_6900_() {
            return false;
        }
    }
}

