/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore;

import codechicken.lib.config.ConfigCallback;
import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigValue;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;

public class BCConfig {
    private static ConfigCategory config;
    private static ConfigCategory clientTag;
    private static ConfigCategory serverTag;
    public static boolean enable_tpx;
    public static boolean clientPermissionVerification;
    @Deprecated
    public static boolean devLog;
    public static boolean darkMode;

    public static void load() {
        config = new ConfigFile("brandonscore").path(Paths.get("./config/brandon3055/BrandonsCore.cfg", new String[0])).load();
        BCConfig.loadServer();
        BCConfig.loadClient();
        config.runSync(ConfigCallback.Reason.MANUAL);
        config.save();
    }

    private static void loadServer() {
        serverTag = config.getCategory("Server");
        serverTag.getValue("enable_tpx").setComment("Allows you to disable the tpx command.").setDefaultBoolean(!ModList.get().isLoaded("mystcraft")).onSync((tag, type) -> {
            enable_tpx = tag.getBoolean();
        });
        serverTag.getValue("clientPermissionVerification").setComment(new String[]{"Uses the right click block event to verify that players have permission to interact with BC / DE blocks.", "This ensures there is no possible way a player can interact with a BC block if a protection system is blocking the interaction", "In theory not even a modified client sending raw packets will be able to bypass this.", "I have added the ability to disable this feature because it seems in rare cases it blocks players who should have access and i have no idea why."}).setDefaultBoolean(true).onSync((tag, type) -> {
            clientPermissionVerification = tag.getBoolean();
        });
    }

    private static void loadClient() {
        clientTag = config.getCategory("Client");
        clientTag.getValue("darkMode").setComment("Enable / Disable dark mode in my GUI's. (This can also be toggled in game from any gui that supports dark mode)").setDefaultBoolean(true).onSync((tag, type) -> {
            darkMode = tag.getBoolean();
        });
    }

    private static void modifyProperty(String name, Consumer<ConfigValue> modifyCallback, String ... groupPath) {
        ConfigCategory parent = config;
        for (String group : groupPath) {
            parent = parent.getCategory(group);
        }
        ConfigValue tag = parent.getValue(name);
        modifyCallback.accept(tag);
        tag.runSync(ConfigCallback.Reason.MANUAL);
        tag.save();
    }

    public static void modifyClientProperty(String name, Consumer<ConfigValue> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Client"}, (Object[])groupPath));
    }

    public static void modifyServerProperty(String name, Consumer<ConfigValue> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Server"}, (Object[])groupPath));
    }

    public static void modifyCommonProperty(String name, Consumer<ConfigValue> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Common"}, (Object[])groupPath));
    }
}

