/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class MapleTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.maple_log.m_49966_();
    private static final BlockState LEAF = SkiesBlocks.maple_leaves.m_49966_();

    public MapleTreeFeature(Codec<TreeConfiguration> config, boolean natural) {
        super(config, natural);
    }

    @Override
    public boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int y;
        int height = rand.m_188503_(4) + ((double)rand.m_188501_() < 0.2 ? 13 : 9);
        if (!this.isAreaOk(world, pos, height, 1, 5, 5)) {
            return false;
        }
        boolean branchType = rand.m_188499_();
        for (y = 0; y <= height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        if (branchType) {
            for (y = -2; y < 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (y < 0) {
                            this.setBlockIfOk(changedLogs, world, pos.m_7918_(x, y + height, z), LEAF);
                            continue;
                        }
                        if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                        this.setBlockIfOk(changedLogs, world, pos.m_7918_(x, y + height, z), LEAF);
                    }
                }
            }
            this.setBlockIfOk(changedLeaves, world, pos.m_6630_(height + 1), LEAF);
            this.setBlockIfOk(changedLeaves, world, pos.m_6630_(height + 2), LEAF);
        } else {
            int z;
            int x;
            for (x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 3) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height - 5, z), LEAF);
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height - 1, z), LEAF);
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height, z), LEAF);
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 4) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height - 4, z), LEAF);
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height - 2, z), LEAF);
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 4 && (Math.abs(x) != 2 || Math.abs(z) != 2)) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height - 3, z), LEAF);
                }
            }
            for (x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 2) continue;
                    this.setBlockIfOk(changedLeaves, world, pos.m_7918_(x, height + 1, z), LEAF);
                }
            }
        }
        if (branchType) {
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(0, height - rand.m_188503_(3) - 3, -1), Direction.NORTH);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(1, height - rand.m_188503_(3) - 3, 0), Direction.EAST);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(0, height - rand.m_188503_(3) - 3, 1), Direction.SOUTH);
            this.setLowerBranch(changedLogs, changedLeaves, world, pos.m_7918_(-1, height - rand.m_188503_(3) - 3, 0), Direction.WEST);
        }
        return true;
    }

    protected void setLowerBranch(BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, BlockPos pos, Direction direction) {
        BlockState axisLog = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction.m_122434_());
        this.setBlockIfOk(changedLogs, world, pos, axisLog);
        this.setBlockIfOk(changedLogs, world, pos.m_5484_(direction, 1), axisLog);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                if (z1 == 1 && x1 == 1) continue;
                this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 1).m_7918_(x, 0, z), LEAF);
                this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 1).m_7918_(x, -1, z), LEAF);
            }
        }
        this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 1).m_7494_(), LEAF);
        this.setBlockIfOk(changedLeaves, world, pos.m_5484_(direction, 1).m_6625_(2), LEAF);
    }

    @Override
    public boolean isValidGround(WorldGenLevel world, BlockState state, BlockPos pos) {
        if (this.natural) {
            return super.isValidGround(world, state, pos) && state.m_60734_() != SkiesBlocks.coarse_lunar_dirt;
        }
        return super.isValidGround(world, state, pos);
    }
}

