/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.items.util.SkiesArmorMaterial;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.structure_gel.api.events.RegisterArmorTrimTexturesEvent;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;

public class SkiesArmorTrims {
    public static final RegistrarHandler<TrimPattern> PATTERN_HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_266063_, (String)"blue_skies").bootstrap(Pattterns::trimBootstrap);
    public static final RegistrarHandler<TrimMaterial> MATERIAL_HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_266076_, (String)"blue_skies").bootstrap(Materials::materialBootstrap);

    public static void registerSpriteData(RegisterArmorTrimTexturesEvent event) {
        Pattterns.patterns().forEach(pattern -> event.registerPatternSprite(pattern));
        Materials.materials().forEach(material -> event.registerMaterialSprite(Materials.assetID((ResourceKey<TrimMaterial>)material), material.m_135782_(), true));
        event.registerPaletteOverride(Materials.PYROPE, Map.of(SkiesArmorMaterial.PYROPE, Materials.darkerID(Materials.PYROPE)));
        event.registerPaletteOverride(Materials.AQUITE, Map.of(SkiesArmorMaterial.AQUITE, Materials.darkerID(Materials.AQUITE)));
        event.registerPaletteOverride(Materials.DIOPSIDE, Map.of(SkiesArmorMaterial.DIOPSIDE, Materials.darkerID(Materials.DIOPSIDE)));
        event.registerPaletteOverride(Materials.CHAROITE, Map.of(SkiesArmorMaterial.CHAROITE, Materials.darkerID(Materials.CHAROITE)));
        event.registerPaletteOverride(Materials.HORIZONITE, Map.of(SkiesArmorMaterial.HORIZONITE, Materials.darkerID(Materials.HORIZONITE)));
        event.registerMaterialBrightness(Materials.MOONSTONE, 15);
        event.registerMaterialBrightness(Materials.SUNSTONE, 15);
    }

    public static interface Pattterns {
        public static final ResourceKey<TrimPattern> BANISHED = PATTERN_HANDLER.key("banished");
        public static final ResourceKey<TrimPattern> THWARTED = PATTERN_HANDLER.key("thwarted");
        public static final ResourceKey<TrimPattern> REGROWTH = PATTERN_HANDLER.key("regrowth");
        public static final ResourceKey<TrimPattern> TOXIC = PATTERN_HANDLER.key("toxic");

        private static void trimBootstrap(BootstapContext<TrimPattern> context) {
            Pattterns.register(context, BANISHED, SkiesItems.banished_trim);
            Pattterns.register(context, THWARTED, SkiesItems.thwarted_trim);
            Pattterns.register(context, REGROWTH, SkiesItems.regrowth_trim);
            Pattterns.register(context, TOXIC, SkiesItems.toxic_trim);
        }

        public static List<ResourceKey<TrimPattern>> patterns() {
            return List.of(BANISHED, THWARTED, REGROWTH, TOXIC);
        }

        private static void register(BootstapContext<TrimPattern> context, ResourceKey<TrimPattern> key, Item templateItem) {
            TrimPattern trimpattern = new TrimPattern(key.m_135782_(), BuiltInRegistries.f_257033_.m_263177_((Object)templateItem), (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_pattern", (ResourceLocation)key.m_135782_())));
            context.m_255272_(key, (Object)trimpattern);
        }
    }

    public static interface Materials {
        public static final ResourceKey<TrimMaterial> MOONSTONE = MATERIAL_HANDLER.key("moonstone");
        public static final ResourceKey<TrimMaterial> SUNSTONE = MATERIAL_HANDLER.key("sunstone");
        public static final ResourceKey<TrimMaterial> HORIZONITE = MATERIAL_HANDLER.key("horizonite");
        public static final ResourceKey<TrimMaterial> FALSITE = MATERIAL_HANDLER.key("falsite");
        public static final ResourceKey<TrimMaterial> VENTIUM = MATERIAL_HANDLER.key("ventium");
        public static final ResourceKey<TrimMaterial> PYROPE = MATERIAL_HANDLER.key("pyrope");
        public static final ResourceKey<TrimMaterial> AQUITE = MATERIAL_HANDLER.key("aquite");
        public static final ResourceKey<TrimMaterial> DIOPSIDE = MATERIAL_HANDLER.key("diopside");
        public static final ResourceKey<TrimMaterial> CHAROITE = MATERIAL_HANDLER.key("charoite");

        private static void materialBootstrap(BootstapContext<TrimMaterial> context) {
            Materials.register(context, MOONSTONE, (ItemLike)SkiesBlocks.moonstone_crystal, "#D9EEF7", 0.108412f);
            Materials.register(context, SUNSTONE, (ItemLike)SkiesBlocks.sunstone_crystal, "#F6CBB7", 0.508412f);
            Materials.register(context, HORIZONITE, (ItemLike)SkiesItems.horizonite_ingot, "#FFA43A", 0.518412f);
            Materials.register(context, FALSITE, (ItemLike)SkiesItems.falsite_ingot, "#8980ED", 0.908412f);
            Materials.register(context, VENTIUM, (ItemLike)SkiesItems.ventium_ingot, "#E8685C", 0.408412f);
            Materials.register(context, PYROPE, (ItemLike)SkiesItems.pyrope_gem, "#FF8CB2", 0.418412f);
            Materials.register(context, AQUITE, (ItemLike)SkiesItems.aquite, "#A3EDF7", 0.808412f);
            Materials.register(context, DIOPSIDE, (ItemLike)SkiesItems.diopside_gem, "#94F252", 0.708412f);
            Materials.register(context, CHAROITE, (ItemLike)SkiesItems.charoite, "#B289D9", 1.008412f);
        }

        public static List<ResourceKey<TrimMaterial>> materials() {
            return List.of(MOONSTONE, SUNSTONE, HORIZONITE, FALSITE, VENTIUM, PYROPE, AQUITE, DIOPSIDE, CHAROITE);
        }

        private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> key, ItemLike ingredient, String hexColor, float itemModelIndex) {
            Materials.register(context, key, ingredient, hexColor, itemModelIndex, Map.of());
        }

        private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> key, ItemLike ingredient, String hexColor, float itemModelIndex, Map<ArmorMaterials, String> overrideArmorMaterials) {
            TrimMaterial trimmaterial = TrimMaterial.m_267605_((String)Materials.assetID(key), (Item)ingredient.m_5456_(), (float)itemModelIndex, (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)key.m_135782_())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)hexColor))), overrideArmorMaterials);
            context.m_255272_(key, (Object)trimmaterial);
        }

        public static String assetID(ResourceKey<TrimMaterial> key) {
            return key.m_135782_().m_135827_() + "-" + key.m_135782_().m_135815_();
        }

        public static String darkerID(ResourceKey<TrimMaterial> key) {
            return Materials.assetID(key) + "_darker";
        }
    }
}

