/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.compat;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorBlock;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class RFToolsBuilderTOPDriver
implements TOPDriver {
    public static final RFToolsBuilderTOPDriver DRIVER = new RFToolsBuilderTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = Tools.getId((BlockState)blockState);
        if (!this.drivers.containsKey(id)) {
            if (blockState.m_60734_() == BuilderModule.BUILDER.get()) {
                this.drivers.put(id, new BuilderDriver());
            } else if (blockState.m_60734_() == BuilderModule.SPACE_CHAMBER_CONTROLLER.get()) {
                this.drivers.put(id, new SpaceChamberControllerDriver());
            } else if (blockState.m_60734_() instanceof ShieldProjectorBlock) {
                this.drivers.put(id, new ShieldProjectorDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class BuilderDriver
    implements TOPDriver {
        private BuilderDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int scan = te.getCurrentLevel();
                probeInfo.text(CompoundText.createLabelInfo((String)"Current level: ", (Object)(scan == -1 ? "not scanning" : Integer.valueOf(scan))));
            }, (String)"Bad tile entity!");
        }
    }

    private static class SpaceChamberControllerDriver
    implements TOPDriver {
        private SpaceChamberControllerDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int channel = te.getChannel();
                probeInfo.text(CompoundText.createLabelInfo((String)"Channel: ", (Object)channel));
                if (channel != -1) {
                    int size = te.getChamberSize();
                    if (size == -1) {
                        probeInfo.text(ChatFormatting.YELLOW + "Chamber not formed!");
                    } else {
                        probeInfo.text(ChatFormatting.GREEN + "Area: " + size + " blocks");
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class ShieldProjectorDriver
    implements TOPDriver {
        private ShieldProjectorDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                boolean composed = te.isShieldComposed();
                if (composed) {
                    probeInfo.text(CompoundText.create().label("Composed: ").info((Component)ComponentFactory.literal((String)"yes")));
                } else {
                    probeInfo.text(CompoundText.create().label("Composed: ").info((Component)ComponentFactory.literal((String)"no")));
                }
                boolean active = te.isShieldActive();
                if (active) {
                    probeInfo.text(CompoundText.create().label("Active: ").info((Component)ComponentFactory.literal((String)"yes")));
                } else {
                    probeInfo.text(CompoundText.create().label("Active: ").info((Component)ComponentFactory.literal((String)"no")));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

