/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.datagen;

import com.teammoeg.caupona.datagen.FileGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JavaFileOutput {
    private final FileGenerator.FileOutput fo;
    private int indent = 0;
    private final List<String> imports = new ArrayList<String>();
    private final List<String> lines = new ArrayList<String>();
    private boolean startedComment;
    private boolean isDocument;

    public JavaFileOutput(FileGenerator fg, String name) {
        this.fo = fg.createOutput(fg.getClassPath(name));
        int idx = name.lastIndexOf(".");
        this.startComment(true, "Copyright (c) 2022 TeamMoeg");
        this.println();
        this.println();
        this.println("This file is part of Caupona.");
        this.println();
        this.println("Caupona is free software: you can redistribute it and/or modify");
        this.println("it under the terms of the GNU General Public License as published by");
        this.println("the Free Software Foundation, version 3.");
        this.println();
        this.println("Caupona is distributed in the hope that it will be useful,");
        this.println("but WITHOUT ANY WARRANTY; without even the implied warranty of");
        this.println("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
        this.println("GNU General Public License for more details.");
        this.println();
        this.println("Specially, we allow this software to be used alongside with closed source software Minecraft(R) and Forge or other modloader.");
        this.println("Any mods or plugins can also use apis provided by forge or api using GPL or open source.");
        this.println();
        this.println("You should have received a copy of the GNU General Public License");
        this.println("along with Caupona. If not, see <https://www.gnu.org/licenses/>.");
        this.endComment();
        this.println();
        this.line().literal("package").literal(name.substring(0, idx)).end();
        this.println();
        this.asImport();
        this.defineBlock("public class " + name.substring(idx + 1));
    }

    public void addImport(Class<?> cls) {
        if (cls.getCanonicalName() == null) {
            throw new IllegalArgumentException("Local or anonymous class is not allowed in import");
        }
        this.imports.add("import " + cls.getCanonicalName() + ";");
    }

    public void addImport(String cls) {
        this.imports.add("import " + cls + ";");
    }

    public void addImportDelimeter() {
        this.imports.add("");
    }

    public void addImportLine(String line) {
        this.imports.add(line);
    }

    public void println() {
        this.println("");
    }

    public void println(String line) {
        this.lines.add("\t".repeat(this.indent) + (this.startedComment && this.isDocument ? "* " : "") + line);
    }

    public LineBuilder line() {
        return new LineBuilder();
    }

    public void comment(String line) {
        this.lines.add("// " + line);
    }

    public void createMap(String modifier, String name, Class<? extends Map> class1, Class<?> kt, Class<?> vt) {
        this.line().literal(modifier).type(Map.class).generic(kt, vt).literal(name).literal("=").newInst(class1).generic(new Class[0]).complete().end();
    }

    public void startComment(boolean isDocument, String line) {
        Object s = "/*";
        if (isDocument) {
            s = (String)s + "*";
        }
        this.println((String)s + " " + line);
        this.startedComment = true;
        this.isDocument = isDocument;
    }

    public void asImport() {
        this.finishAll();
        this.imports.addAll(this.lines);
        this.lines.clear();
    }

    public void endComment() {
        this.isDocument = false;
        this.startedComment = false;
        this.println("*/");
    }

    public void defineBlock(String signature) {
        if (this.startedComment) {
            throw new IllegalStateException("Cannot define block in comment!");
        }
        this.println(signature + " {");
        ++this.indent;
    }

    public void endBlock() {
        if (this.startedComment) {
            throw new IllegalStateException("Cannot end block in comment!");
        }
        --this.indent;
        this.println("}");
    }

    public void finishAll() {
        if (this.startedComment) {
            this.endComment();
        }
        while (this.indent > 0) {
            this.endBlock();
        }
    }

    public FileGenerator.FileOutput complete() {
        this.finishAll();
        for (String s : this.imports) {
            this.fo.getPrint().println(s);
        }
        this.fo.getPrint().println("/* This file is generated by data generators, any modification by hand would lost. */");
        for (String s : this.lines) {
            this.fo.getPrint().println(s);
        }
        return this.fo;
    }

    public class LineBuilder {
        private int parentheses;
        private boolean isLastLiteral = false;
        private StringBuilder current = new StringBuilder();

        public LineBuilder startP() {
            ++this.parentheses;
            this.current.append("(");
            this.isLastLiteral = false;
            return this;
        }

        public LineBuilder string(String str) {
            if (this.isLastLiteral) {
                this.current.append(" ");
            }
            this.current.append("\"").append(str.replaceAll("\"", "\\\"")).append("\"");
            return this;
        }

        public LineBuilder endP() {
            --this.parentheses;
            this.current.append(")");
            this.isLastLiteral = false;
            return this;
        }

        public LineBuilder type(Class<?> cls) {
            this.literal(cls.getSimpleName());
            return this;
        }

        public LineBuilder assign(Class<?> cls, String name) {
            return this.type(cls).literal(name).literal("=");
        }

        public ParamBuilder<LineBuilder> call(String lit) {
            this.literal(lit);
            this.isLastLiteral = false;
            return new ParamBuilder<LineBuilder>(this);
        }

        public LineBuilder literal(String lit) {
            if (this.isLastLiteral) {
                this.current.append(" ");
            }
            int cnt = 0;
            int st = 0;
            while ((st = lit.indexOf("(", st + 1)) >= 0) {
                ++cnt;
            }
            st = 0;
            while ((st = lit.indexOf(")", st + 1)) >= 0) {
                --cnt;
            }
            this.isLastLiteral = true;
            this.parentheses += cnt;
            this.current.append(lit);
            return this;
        }

        public LineBuilder dot() {
            this.current.append(".");
            this.isLastLiteral = false;
            return this;
        }

        public LineBuilder generic(Class<?> ... classes) {
            this.current.append("<");
            boolean isFirst = true;
            this.isLastLiteral = false;
            for (Class<?> c : classes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.comma();
                }
                this.literal(c.getSimpleName());
            }
            this.current.append(">");
            this.isLastLiteral = true;
            return this;
        }

        public ParamBuilder<LineBuilder> newInst(String cls) {
            this.literal("new").literal(cls);
            return new ParamBuilder<LineBuilder>(this);
        }

        public ParamBuilder<LineBuilder> newInst(Class<?> cls) {
            this.literal("new").type(cls);
            return new ParamBuilder<LineBuilder>(this);
        }

        public LineBuilder comma() {
            this.isLastLiteral = true;
            this.current.append(",");
            return this;
        }

        public void endLine() {
            while (this.parentheses > 0) {
                this.endP();
            }
            JavaFileOutput.this.println(this.current.toString());
        }

        public void end() {
            while (this.parentheses > 0) {
                this.endP();
            }
            JavaFileOutput.this.println(this.current.toString() + ";");
        }

        public class ParamBuilder<T> {
            boolean isFirst = true;
            T par;

            public ParamBuilder(T par) {
                this.par = par;
            }

            public ParamBuilder<T> paramLiteral(String s) {
                this.param();
                LineBuilder.this.literal(s);
                return this;
            }

            public ParamBuilder<T> paramString(String s) {
                this.param();
                LineBuilder.this.string(s);
                return this;
            }

            public ParamBuilder<T> generic(Class<?> ... classes) {
                LineBuilder.this.generic(classes);
                return this;
            }

            public ParamBuilder<ParamBuilder<T>> paramNewInst(String s) {
                this.param();
                LineBuilder.this.newInst(s);
                return new ParamBuilder<ParamBuilder<T>>(this);
            }

            public ParamBuilder<ParamBuilder<T>> paramNewInst(Class<?> s) {
                this.param();
                LineBuilder.this.newInst(s);
                return new ParamBuilder<ParamBuilder<T>>(this);
            }

            public ParamBuilder<T> param() {
                if (!this.isFirst) {
                    LineBuilder.this.comma();
                } else {
                    LineBuilder.this.startP();
                }
                this.isFirst = false;
                return this;
            }

            public T complete() {
                if (this.isFirst) {
                    LineBuilder.this.startP();
                }
                LineBuilder.this.endP();
                return this.par;
            }
        }
    }
}

