/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes.numbers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.TranslationProvider;
import com.teammoeg.caupona.data.recipes.CookIngredients;
import com.teammoeg.caupona.data.recipes.IPendingContext;
import com.teammoeg.caupona.util.FloatemTagStack;
import com.teammoeg.caupona.util.Utils;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemType
implements CookIngredients {
    Item type;
    ResourceLocation loc;

    public ItemType(JsonElement jo) {
        this.loc = new ResourceLocation(jo.getAsJsonObject().get("item").getAsString());
        this.type = (Item)ForgeRegistries.ITEMS.getValue(this.loc);
    }

    public ItemType(Item type) {
        this.type = type;
        this.loc = Utils.getRegistryName(type);
    }

    @Override
    public Float apply(IPendingContext t) {
        if (this.type == null) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(t.getOfItem(i -> i.m_41720_().equals(this.type)));
    }

    @Override
    public boolean fits(FloatemTagStack stack) {
        return stack.getItem().equals(this.type);
    }

    @Override
    public JsonElement serialize() {
        JsonObject th = new JsonObject();
        th.addProperty("item", this.loc.toString());
        return th;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.loc);
    }

    public ItemType(FriendlyByteBuf buffer) {
        this.loc = buffer.m_130281_();
        this.type = (Item)ForgeRegistries.ITEMS.getValue(this.loc);
    }

    @Override
    public String getType() {
        return "item";
    }

    @Override
    public Stream<CookIngredients> getItemRelated() {
        return Stream.of(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemType)) {
            return false;
        }
        ItemType other = (ItemType)obj;
        return !(this.loc == null ? other.loc != null : !this.loc.equals((Object)other.loc));
    }

    @Override
    public Stream<ResourceLocation> getTags() {
        return Stream.empty();
    }

    @Override
    public String getTranslation(TranslationProvider p) {
        return p.getTranslation(this.type.m_5524_(), new Object[0]);
    }

    @Override
    public Stream<ItemStack> getStacks() {
        return Stream.of(new ItemStack((ItemLike)this.type));
    }
}

