/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teammoeg.caupona.data.IDataRecipe;
import com.teammoeg.caupona.data.InvalidRecipeException;
import com.teammoeg.caupona.fluid.SoupFluid;
import com.teammoeg.caupona.item.StewItem;
import com.teammoeg.caupona.util.StewInfo;
import com.teammoeg.caupona.util.Utils;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class AspicMeltingRecipe
extends IDataRecipe {
    public static List<AspicMeltingRecipe> recipes;
    public static RegistryObject<RecipeType<Recipe<?>>> TYPE;
    public static RegistryObject<RecipeSerializer<?>> SERIALIZER;
    public Ingredient aspic;
    public Fluid fluid;
    public int amount = 250;
    public int time = 100;

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TYPE.get();
    }

    public AspicMeltingRecipe(ResourceLocation id, JsonObject jo) {
        super(id);
        this.aspic = Ingredient.m_43917_((JsonElement)jo.get("aspic"));
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(jo.get("fluid").getAsString()));
        if (jo.has("time")) {
            this.time = jo.get("time").getAsInt();
        }
        if (jo.has("amount")) {
            this.amount = jo.get("amount").getAsInt();
        }
        if (this.fluid == null || this.fluid == Fluids.f_76191_) {
            throw new InvalidRecipeException();
        }
    }

    public AspicMeltingRecipe(ResourceLocation id, FriendlyByteBuf pb) {
        super(id);
        this.aspic = Ingredient.m_43940_((FriendlyByteBuf)pb);
        this.fluid = (Fluid)pb.readRegistryIdUnsafe(ForgeRegistries.FLUIDS);
        this.amount = pb.m_130242_();
        this.time = pb.m_130242_();
    }

    public AspicMeltingRecipe(ResourceLocation id, Ingredient aspic, Fluid fluid) {
        super(id);
        this.aspic = aspic;
        this.fluid = fluid;
    }

    public void write(FriendlyByteBuf pack) {
        this.aspic.m_43923_(pack);
        pack.writeRegistryIdUnsafe(ForgeRegistries.FLUIDS, (Object)this.fluid);
        pack.m_130130_(this.amount);
        pack.m_130130_(this.time);
    }

    @Override
    public void serializeRecipeData(JsonObject jo) {
        jo.add("aspic", this.aspic.m_43942_());
        jo.addProperty("fluid", Utils.getRegistryName(this.fluid).toString());
        jo.addProperty("amount", (Number)this.amount);
        jo.addProperty("time", (Number)this.time);
    }

    public FluidStack handle(ItemStack s) {
        StewInfo si = StewItem.getInfo(s);
        FluidStack fs = new FluidStack(this.fluid, this.amount);
        SoupFluid.setInfo(fs, si);
        return fs;
    }

    public StewInfo info(ItemStack s) {
        StewInfo si = StewItem.getInfo(s);
        return si;
    }

    public static AspicMeltingRecipe find(ItemStack aspic) {
        return recipes.stream().filter(t -> t.aspic.test(aspic)).findFirst().orElse(null);
    }
}

