/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.caupona.compat.jei.category;

import com.teammoeg.caupona.data.recipes.BoilingRecipe;
import com.teammoeg.caupona.util.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class BoilingCategory
implements IRecipeCategory<BoilingRecipe> {
    public static RecipeType<BoilingRecipe> TYPE = RecipeType.create((String)"caupona", (String)"boiling", BoilingRecipe.class);
    private IDrawable BACKGROUND;
    private IDrawable ICON;

    public BoilingCategory(IGuiHelper guiHelper) {
        this.ICON = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("caupona", "nail_soup"))));
        ResourceLocation guiMain = new ResourceLocation("caupona", "textures/gui/jei/boiling.png");
        this.BACKGROUND = guiHelper.createDrawable(guiMain, 0, 0, 127, 63);
    }

    public Component getTitle() {
        return Utils.translate("gui.jei.category.caupona.boiling.title");
    }

    public void draw(BoilingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        String burnTime = String.valueOf((float)recipe.time / 20.0f) + "s";
        stack.m_280488_(Minecraft.m_91087_().f_91062_, burnTime, 103, 55, 0xFFFFFF);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BoilingRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 30, 9).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.before, 250))).setFluidRenderer(1250L, false, 16, 46);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 83, 9).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.after, 250))).setFluidRenderer(1250L, false, 16, 46);
    }

    public RecipeType<BoilingRecipe> getRecipeType() {
        return TYPE;
    }
}

