/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.stacks.AEKey;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;

public class AdvPatternEncoderPacket
implements IMessage<AdvPatternEncoderPacket> {
    private LinkedHashMap<AEKey, Direction> dirMap;

    public AdvPatternEncoderPacket() {
        this.dirMap = new LinkedHashMap();
    }

    public AdvPatternEncoderPacket(LinkedHashMap<AEKey, Direction> dirMap) {
        this.dirMap = dirMap;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.dirMap.size());
        for (Map.Entry<AEKey, Direction> entry : this.dirMap.entrySet()) {
            AEKey.writeKey((FriendlyByteBuf)buf, (AEKey)entry.getKey());
            Direction dir = entry.getValue();
            if (dir == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            buf.m_130068_((Enum)entry.getValue());
        }
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.dirMap = new LinkedHashMap();
        int size = buf.readInt();
        for (int x = 0; x < size; ++x) {
            AEKey key = AEKey.readKey((FriendlyByteBuf)buf);
            Direction dir = buf.readBoolean() ? (Direction)buf.m_130066_(Direction.class) : null;
            this.dirMap.put(key, dir);
        }
    }

    public void onMessage(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AdvPatternEncoderScreen) {
            AdvPatternEncoderScreen encoderGui = (AdvPatternEncoderScreen)screen;
            encoderGui.update(this.dirMap);
        }
    }

    public Class<AdvPatternEncoderPacket> getPacketClass() {
        return AdvPatternEncoderPacket.class;
    }

    public boolean isClient() {
        return true;
    }
}

