/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.api.AAESettings;

public class AAEConfigButtonPacket
implements IMessage<AAEConfigButtonPacket> {
    private Setting<?> option;
    private boolean rotationDirection;

    public AAEConfigButtonPacket() {
    }

    public AAEConfigButtonPacket(Setting<?> option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
    }

    public void fromBytes(FriendlyByteBuf stream) {
        this.option = AAESettings.getOrThrow(stream.m_130277_());
        this.rotationDirection = stream.readBoolean();
    }

    public void toBytes(FriendlyByteBuf data) {
        data.m_130070_(this.option.getName());
        data.writeBoolean(this.rotationDirection);
    }

    public void onMessage(Player player) {
        AEBaseMenu baseMenu;
        Object object;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)abstractContainerMenu).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                AELog.info((String)"Ignoring unsupported setting %s sent by client on %s", (Object[])new Object[]{this.option, baseMenu.getTarget()});
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        Enum currentValue = cm.getSetting(setting);
        Enum nextValue = EnumCycler.rotateEnum((Enum)currentValue, (boolean)this.rotationDirection, (Set)setting.getValues());
        cm.putSetting(setting, nextValue);
    }

    public Class<AAEConfigButtonPacket> getPacketClass() {
        return AAEConfigButtonPacket.class;
    }

    public boolean isClient() {
        return false;
    }
}

