/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.patternencoder;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.OutputSlot;
import appeng.menu.slot.RestrictedInputSlot;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.inventory.AdvPatternEncoderHost;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsEncoder;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPattern;
import net.pedroksl.advanced_ae.common.patterns.AdvProcessingPatternItem;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.AdvPatternEncoderPacket;

public class AdvPatternEncoderMenu
extends AEBaseMenu {
    private final RestrictedInputSlot inputSlot;
    private final OutputSlot outputSlot;
    private final AdvPatternEncoderHost host;

    public AdvPatternEncoderMenu(int id, Inventory playerInventory, AdvPatternEncoderHost host) {
        super(AAEMenus.ADV_PATTERN_ENCODER.get(), id, playerInventory, (Object)host);
        this.createPlayerInventorySlots(playerInventory);
        this.host = host;
        this.inputSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.ENCODED_PATTERN, (InternalInventory)host.getInventory(), 0);
        this.addSlot((Slot)this.inputSlot, SlotSemantics.ENCODED_PATTERN);
        this.outputSlot = new OutputSlot((InternalInventory)host.getInventory(), 1, null);
        this.addSlot((Slot)this.outputSlot, SlotSemantics.MACHINE_OUTPUT);
        this.host.setInventoryChangedHandler(this::onChangeInventory);
        if (this.inputSlot.m_6657_()) {
            this.decodeInputPattern();
        }
    }

    public AdvPatternEncoderHost getHost() {
        return this.host;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.host.getInventory()) {
            if (slot == 0) {
                if (this.inputSlot.m_6657_() && !this.outputSlot.m_6657_()) {
                    this.decodeInputPattern();
                } else if (!this.inputSlot.m_6657_()) {
                    this.clearDecodedPattern();
                    this.outputSlot.m_5852_(ItemStack.f_41583_);
                }
            } else if (slot == 1 && !this.outputSlot.m_6657_()) {
                this.clearDecodedPattern();
                this.inputSlot.m_5852_(ItemStack.f_41583_);
            }
        }
    }

    private void decodeInputPattern() {
        ItemStack stack = this.inputSlot.m_7993_();
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().m_9236_(), (boolean)false);
        if (details == null) {
            return;
        }
        if (!(details instanceof AEProcessingPattern)) {
            return;
        }
        AEProcessingPattern pattern = (AEProcessingPattern)details;
        boolean advPattern = details instanceof AdvProcessingPattern;
        AdvProcessingPattern advDetails = advPattern ? (AdvProcessingPattern)details : null;
        GenericStack[] sparseInputs = pattern.getSparseInputs();
        LinkedHashMap<AEKey, Direction> inputList = new LinkedHashMap<AEKey, Direction>();
        for (GenericStack input : sparseInputs) {
            if (input == null || inputList.containsKey(input.what())) continue;
            Direction dir = advPattern ? advDetails.getDirectionSideForInputKey(input.what()) : null;
            inputList.put(input.what(), dir);
        }
        if (advPattern) {
            this.outputSlot.m_5852_(stack.m_41777_());
        } else {
            ItemStack newAdvPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(pattern.getSparseInputs(), pattern.getSparseOutputs(), inputList);
            this.outputSlot.m_5852_(newAdvPattern);
        }
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket(inputList), sp);
        }
    }

    private void clearDecodedPattern() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket(), sp);
        }
    }

    public void update(AEKey key, Direction dir) {
        AdvProcessingPatternItem patternItem;
        AdvProcessingPattern pattern;
        Item item;
        if (!this.outputSlot.m_6657_()) {
            this.copyItemToOutputSlot();
        }
        if ((item = this.outputSlot.m_7993_().m_41720_()) instanceof AdvProcessingPatternItem && (pattern = (patternItem = (AdvProcessingPatternItem)item).decode(this.outputSlot.m_7993_(), this.getPlayer().m_9236_(), false)) != null) {
            HashMap dirMap = pattern.getDirectionMap();
            dirMap.put(key, dir);
            ItemStack newPattern = AdvPatternDetailsEncoder.encodeProcessingPattern(pattern.getSparseInputs(), pattern.getSparseOutputs(), dirMap);
            this.outputSlot.m_5852_(newPattern);
            Player player = this.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                AAENetworkHandler.INSTANCE.sendTo(new AdvPatternEncoderPacket((LinkedHashMap<AEKey, Direction>)dirMap), sp);
            }
        }
    }

    public void copyItemToOutputSlot() {
        ItemStack stack = this.inputSlot.m_7993_();
        IPatternDetails details = PatternDetailsHelper.decodePattern((ItemStack)stack, (Level)this.getPlayer().m_9236_(), (boolean)false);
        if (details == null) {
            return;
        }
        if (!(details instanceof AEProcessingPattern)) {
            return;
        }
        AEProcessingPattern pattern = (AEProcessingPattern)details;
        boolean advPattern = details instanceof AdvProcessingPattern;
        if (advPattern) {
            this.outputSlot.m_5852_(stack);
        } else {
            ItemStack newAdvPattern = AAEItems.ADV_PROCESSING_PATTERN.get().encode(pattern.getSparseInputs(), pattern.getSparseOutputs());
            this.outputSlot.m_5852_(newAdvPattern);
        }
    }

    public static interface inventoryChangedHandler {
        public void handleChange(InternalInventory var1, int var2);
    }
}

