/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.stacks.GenericStack;
import appeng.api.storage.ISubMenuHost;
import appeng.menu.MenuOpener;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuLocator;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorFilterConfigMenu;

public class QuantumArmorMagnetMenu
extends QuantumArmorFilterConfigMenu {
    @GuiSync(value=8)
    public boolean blacklist;
    @GuiSync(value=9)
    public int currentValue = -1;
    private static final String SET_BLACKLIST = "set_blacklist";
    private static final String SET_CURRENT_VALUE = "set_current_value";

    public QuantumArmorMagnetMenu(int id, Inventory playerInventory, ISubMenuHost host) {
        super(AAEMenus.QUANTUM_ARMOR_MAGNET.get(), id, playerInventory, host);
        this.registerClientAction(SET_BLACKLIST, Boolean.class, this::setBlacklist);
        this.registerClientAction(SET_CURRENT_VALUE, Integer.class, this::setCurrentValue);
    }

    public static void open(ServerPlayer player, MenuLocator locator, int slotIndex, List<GenericStack> filterList, int currentValue, boolean blacklist) {
        MenuOpener.open(AAEMenus.QUANTUM_ARMOR_MAGNET.get(), (Player)player, (MenuLocator)locator);
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof QuantumArmorMagnetMenu) {
            QuantumArmorMagnetMenu cca = (QuantumArmorMagnetMenu)abstractContainerMenu;
            cca.setUpgradeType(UpgradeType.MAGNET);
            cca.setSlotIndex(slotIndex);
            cca.setFilterList(filterList);
            cca.setBlacklist(blacklist);
            cca.setCurrentValue(currentValue);
            cca.m_38946_();
        }
    }

    public void setBlacklist(boolean blacklist) {
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(SET_BLACKLIST, blacklist);
            return;
        }
        this.blacklist = blacklist;
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(this.slotIndex);
        Item item2 = stack.m_41720_();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.upgradeType) && item.hasUpgrade(stack, this.upgradeType)) {
            item.setUpgradeExtra(stack, this.upgradeType, blacklist);
        }
    }

    public void setCurrentValue(int value) {
        int currentValue;
        QuantumArmorBase item;
        if (this.isClientSide()) {
            this.sendClientAction(SET_CURRENT_VALUE, value);
            return;
        }
        this.currentValue = value;
        ItemStack stack = this.getPlayer().m_150109_().m_8020_(this.slotIndex);
        Item item2 = stack.m_41720_();
        if (item2 instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).getPossibleUpgrades().contains((Object)this.upgradeType) && item.hasUpgrade(stack, this.upgradeType) && ((currentValue = item.getUpgradeValue(stack, this.upgradeType, -1)) == -1 || currentValue != value)) {
            item.setUpgradeValue(stack, this.upgradeType, value);
        }
    }

    @Override
    public void returnFromSetAmountMenu() {
        List<GenericStack> filterList = this.makeFilterList();
        Player player = this.getPlayerInventory().f_35978_;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            QuantumArmorMagnetMenu.open(serverPlayer, this.getLocator(), this.slotIndex, filterList, this.currentValue, this.blacklist);
        }
    }
}

