/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.events;

import appeng.api.config.Actionable;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class AAELivingEntityEvents {
    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(AAELivingEntityEvents::checkInvulnerability);
        MinecraftForge.EVENT_BUS.addListener(AAELivingEntityEvents::incomingDamage);
        MinecraftForge.EVENT_BUS.addListener(AAELivingEntityEvents::breath);
        MinecraftForge.EVENT_BUS.addListener(AAELivingEntityEvents::jumpEvent);
        MinecraftForge.EVENT_BUS.addListener(AAELivingEntityEvents::livingFallDamage);
    }

    public static void checkInvulnerability(LivingAttackEvent event) {
        LivingEntity target = event.getEntity();
        if (target instanceof Player) {
            Random randomGenerator;
            double chance;
            QuantumArmorBase item;
            ItemStack bootStack;
            Item item2;
            QuantumArmorBase item3;
            Player player = (Player)target;
            ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
            Item item4 = chestStack.m_41720_();
            if (item4 instanceof QuantumArmorBase && (item3 = (QuantumArmorBase)item4).isUpgradeEnabledAndPowered(chestStack, UpgradeType.LAVA_IMMUNITY) && (event.getSource().m_276093_(DamageTypes.f_268546_) || event.getSource().m_276093_(DamageTypes.f_268631_) || event.getSource().m_276093_(DamageTypes.f_268468_))) {
                player.m_7311_(0);
                event.setCanceled(true);
                item3.consumeEnergy(player, chestStack, UpgradeType.LAVA_IMMUNITY);
            }
            if ((item2 = (bootStack = player.m_6844_(EquipmentSlot.FEET)).m_41720_()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(bootStack, UpgradeType.EVASION) && (chance = (randomGenerator = new Random()).nextDouble(100.0)) < (double)AAEConfig.instance().getEvasionChance()) {
                event.setCanceled(true);
                item.consumeEnergy(player, bootStack, UpgradeType.EVASION);
            }
        }
    }

    public static void incomingDamage(LivingDamageEvent event) {
        LivingEntity target = event.getEntity();
        if (target.m_6084_() && event.getAmount() > 0.0f && target instanceof Player) {
            Player player = (Player)target;
            float maxAbsorption = event.getAmount() * (float)AAEConfig.instance().getPercentageDamageAbsorption() / 100.0f;
            float amountPerPiece = maxAbsorption / 4.0f;
            float absorbed = 0.0f;
            for (ItemStack stack : player.m_6168_()) {
                Item item;
                if (stack == null || stack.m_41619_() || !((item = stack.m_41720_()) instanceof QuantumArmorBase)) continue;
                QuantumArmorBase item2 = (QuantumArmorBase)item;
                double extracted = item2.extractAEPower(stack, amountPerPiece * 1000.0f, Actionable.MODULATE);
                absorbed += (float)extracted / 1000.0f;
            }
            if (absorbed > 0.0f) {
                event.setAmount(Math.max(0.0f, event.getAmount() - absorbed));
            }
            if (event.getAmount() < 1.0f) {
                event.setCanceled(true);
            }
        }
    }

    public static void breath(LivingBreatheEvent event) {
        QuantumArmorBase item;
        Player player;
        ItemStack stack;
        Item item2;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (item2 = (stack = (player = (Player)livingEntity).m_6844_(EquipmentSlot.HEAD)).m_41720_()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(stack, UpgradeType.WATER_BREATHING)) {
            event.setCanBreathe(true);
            item.consumeEnergy(player, stack, UpgradeType.WATER_BREATHING);
        }
    }

    public static void jumpEvent(LivingEvent.LivingJumpEvent event) {
        QuantumArmorBase item;
        Player player;
        ItemStack stack;
        Item item2;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (item2 = (stack = (player = (Player)livingEntity).m_6844_(EquipmentSlot.FEET)).m_41720_()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).isUpgradeEnabledAndPowered(stack, UpgradeType.JUMP_HEIGHT)) {
            UpgradeType.JUMP_HEIGHT.ability.execute(player.m_9236_(), player, stack);
            item.consumeEnergy(player, stack, UpgradeType.JUMP_HEIGHT);
        }
    }

    public static void livingFallDamage(LivingFallEvent event) {
        QuantumArmorBase item;
        ServerPlayer player;
        ItemStack stack;
        Item item2;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (item2 = (stack = (player = (ServerPlayer)livingEntity).m_6844_(EquipmentSlot.FEET)).m_41720_()) instanceof QuantumArmorBase && (item = (QuantumArmorBase)item2).extractAEPower(stack, 10.0, Actionable.SIMULATE) > 0.0) {
            event.setDistance(0.0f);
        }
    }
}

