/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.capabilities.Capabilities;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import appeng.util.BlockApiCache;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.capabilities.Capability;

public class SimulatedStorageImportStrategy<T, S> {
    private final BlockApiCache<T> cache;
    private final BlockApiCache<MEStorage> meCache;
    private final HandlerStrategy<T, S> conversion;
    private final Direction fromSide;

    public SimulatedStorageImportStrategy(Capability<T> capability, HandlerStrategy<T, S> conversion, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockApiCache.create(capability, (ServerLevel)level, (BlockPos)fromPos);
        this.meCache = BlockApiCache.create((Capability)Capabilities.STORAGE, (ServerLevel)level, (BlockPos)fromPos);
        this.conversion = conversion;
        this.fromSide = fromSide;
    }

    public long simulateTransfer(AEKey what, long toImport, IActionSource src) {
        KeyCounter keys;
        if (what.getType() != this.conversion.getKeyType()) {
            return 0L;
        }
        MEStorage meHandler = (MEStorage)this.meCache.find(this.fromSide);
        if (meHandler != null && (keys = meHandler.getAvailableStacks()).get(what) > 0L) {
            return keys.get(what);
        }
        Object adjacentHandler = this.cache.find(this.fromSide);
        if (adjacentHandler == null) {
            return 0L;
        }
        ExternalStorageFacade adjacentStorage = this.conversion.getFacade(adjacentHandler);
        long amount = adjacentStorage.extract(what, toImport, Actionable.SIMULATE, src);
        if (amount == 0L && adjacentStorage.containsAnyFuzzy(Set.of(what))) {
            KeyCounter stacks = adjacentStorage.getAvailableStacks();
            amount = stacks.get(what);
        }
        return Math.max(0L, amount);
    }
}

