/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.core.localization.LocalizationEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import org.jetbrains.annotations.Nullable;

public class AAEToolbarActionButton
extends AAEIconButton {
    private static Map<AAEActionItems, ButtonAppearance> appearances;
    private final AAEActionItems action;

    public AAEToolbarActionButton(AAEActionItems action, Runnable onPress) {
        this(action, (AAEActionItems a) -> onPress.run());
    }

    public AAEToolbarActionButton(AAEActionItems action, Consumer<AAEActionItems> onPress) {
        super(btn -> onPress.accept(action));
        this.action = action;
        if (appearances == null) {
            appearances = new HashMap<AAEActionItems, ButtonAppearance>();
            AAEToolbarActionButton.registerApp(AAEIcon.DIRECTION_OUTPUT, AAEActionItems.DIRECTIONAL_OUTPUT, AAEText.DirectionalOutput, AAEText.DirectionOutputHint);
        }
    }

    private static void registerApp(AAEIcon icon, AAEActionItems action, LocalizationEnum title, LocalizationEnum hint) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)title.text());
        Collections.addAll(lines, hint.text());
        appearances.put(action, new ButtonAppearance(icon, null, lines));
    }

    public AAEActionItems getAction() {
        return this.action;
    }

    @Nullable
    private ButtonAppearance getAppearance() {
        if (this.action != null) {
            return appearances.get((Object)this.action);
        }
        return null;
    }

    @Override
    protected AAEIcon getIcon() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.icon != null) {
            return app.icon;
        }
        return AAEIcon.TOOLBAR_BUTTON_BACKGROUND;
    }

    @Override
    public List<Component> getTooltipMessage() {
        ButtonAppearance app = this.getAppearance();
        if (app != null && app.tooltipLines() != null) {
            return app.tooltipLines();
        }
        return List.of();
    }

    private record ButtonAppearance(@Nullable AAEIcon icon, @Nullable Item item, List<Component> tooltipLines) {
    }
}

