/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreRangedWeapon;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.client.util.ModelPropertiesHelper;
import net.silentchaos512.gear.item.gear.GearArrowItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class GearCrossbowItem
extends CrossbowItem
implements ICoreRangedWeapon {
    private static final int MIN_CHARGE_TIME = 5;
    private static final int MAX_CHARGE_TIME = 50;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;

    public GearCrossbowItem() {
        super(GearHelper.getBaseItemProperties().m_41499_(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.CROSSBOW;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (GearHelper.isBroken(itemstack)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (GearCrossbowItem.m_40932_((ItemStack)itemstack)) {
            GearCrossbowItem.fireProjectiles(worldIn, (LivingEntity)playerIn, handIn, itemstack, GearCrossbowItem.m_40945_(itemstack), 1.0f);
            GearCrossbowItem.m_40884_((ItemStack)itemstack, (boolean)false);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        if (!playerIn.m_6298_(itemstack).m_41619_()) {
            if (!GearCrossbowItem.m_40932_((ItemStack)itemstack)) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
                playerIn.m_6672_(handIn);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int i = this.m_8105_(stack) - timeLeft;
        float f = GearCrossbowItem.getCharge(i, stack);
        if (f >= 1.0f && !GearCrossbowItem.m_40932_((ItemStack)stack) && GearCrossbowItem.hasAmmo(entityLiving, stack)) {
            GearCrossbowItem.m_40884_((ItemStack)stack, (boolean)true);
            SoundSource soundcategory = entityLiving instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            worldIn.m_6263_(null, entityLiving.m_20185_(), entityLiving.m_20186_(), entityLiving.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (worldIn.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean hasAmmo(LivingEntity shooter, ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
        ItemStack itemstack = shooter.m_6298_(stack);
        ItemStack itemstack1 = itemstack.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.m_41777_();
            }
            if (itemstack.m_41619_() && flag) {
                itemstack = new ItemStack((ItemLike)Items.f_42412_);
                itemstack1 = itemstack.m_41777_();
            }
            if (GearCrossbowItem.m_40862_(shooter, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean m_40862_(LivingEntity entityIn, ItemStack crossbow, ItemStack ammo, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (GearCrossbowItem.isAmmoInvalid(ammo)) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && ammo.m_41720_() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            itemstack = GearCrossbowItem.splitOneAmmo(ammo);
            if (ammo.m_41619_() && entityIn instanceof Player) {
                ((Player)entityIn).m_150109_().m_36057_(ammo);
            }
        } else {
            itemstack = ammo.m_41777_();
        }
        GearCrossbowItem.m_40928_(crossbow, itemstack);
        return true;
    }

    private static boolean isAmmoInvalid(ItemStack ammo) {
        return ammo.m_41619_() || ammo.m_41720_() instanceof GearArrowItem && GearHelper.isBroken(ammo);
    }

    private static ItemStack splitOneAmmo(ItemStack ammo) {
        if (ammo.m_41720_() instanceof GearArrowItem) {
            ItemStack copy = ammo.m_41777_();
            ammo.m_41721_(ammo.m_41773_() + 1);
            copy.m_41721_(copy.m_41776_() - 1);
            return copy;
        }
        return ammo.m_41620_(1);
    }

    private static void m_40928_(ItemStack crossbow, ItemStack projectile) {
        CompoundTag compoundnbt = crossbow.m_41784_();
        ListTag listnbt = compoundnbt.m_128425_("ChargedProjectiles", 9) ? compoundnbt.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag compoundnbt1 = new CompoundTag();
        projectile.m_41739_(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
    }

    private static List<ItemStack> m_40941_(ItemStack p_220018_0_) {
        ListTag listnbt;
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundnbt = p_220018_0_.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("ChargedProjectiles", 9) && (listnbt = compoundnbt.m_128437_("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt1 = listnbt.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundnbt1));
            }
        }
        return list;
    }

    private static void clearProjectiles(ItemStack p_220027_0_) {
        CompoundTag compoundnbt = p_220027_0_.m_41783_();
        if (compoundnbt != null) {
            ListTag listnbt = compoundnbt.m_128437_("ChargedProjectiles", 9);
            listnbt.clear();
            compoundnbt.m_128365_("ChargedProjectiles", (Tag)listnbt);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 133700;
    }

    private SoundEvent m_40851_(int p_220025_1_) {
        switch (p_220025_1_) {
            case 1: {
                return SoundEvents.f_11844_;
            }
            case 2: {
                return SoundEvents.f_11845_;
            }
            case 3: {
                return SoundEvents.f_11846_;
            }
        }
        return SoundEvents.f_11843_;
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)GearCrossbowItem.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static void m_40894_(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, ItemStack projectile, float p_220016_5_, boolean p_220016_6_, float p_220016_7_, float p_220016_8_, float p_220016_9_) {
        if (!world.f_46443_) {
            AbstractArrow iprojectile;
            boolean flag;
            boolean bl = flag = projectile.m_41720_() == Items.f_42688_;
            if (flag) {
                iprojectile = new FireworkRocketEntity(world, projectile, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                iprojectile = GearCrossbowItem.m_40914_(world, shooter, crossbow, projectile);
                if (p_220016_6_ || p_220016_9_ != 0.0f) {
                    iprojectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob icrossbowuser = (CrossbowAttackMob)shooter;
                LivingEntity attackTarget = icrossbowuser.m_5448_();
                if (attackTarget != null) {
                    icrossbowuser.m_5811_(attackTarget, crossbow, (Projectile)iprojectile, p_220016_9_);
                }
            } else {
                Vec3 vec31 = shooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(p_220016_9_ * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                iprojectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), p_220016_7_, p_220016_8_);
            }
            crossbow.m_41622_(flag ? 3 : 1, shooter, p_220017_1_ -> p_220017_1_.m_21190_(hand));
            world.m_7967_((Entity)iprojectile);
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, p_220016_5_);
        }
    }

    private static AbstractArrow m_40914_(Level world, LivingEntity shooter, ItemStack crossbow, ItemStack projectile) {
        ArrowItem arrowitem = (ArrowItem)(projectile.m_41720_() instanceof ArrowItem ? projectile.m_41720_() : Items.f_42412_);
        AbstractArrow arrowEntity = arrowitem.m_6394_(world, projectile, shooter);
        if (shooter instanceof Player) {
            arrowEntity.m_36762_(true);
        }
        arrowEntity.m_36781_(arrowEntity.m_36789_() - 2.0 + (double)GearData.getStat(crossbow, ItemStats.RANGED_DAMAGE));
        arrowEntity.m_36740_(SoundEvents.f_11840_);
        arrowEntity.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbow);
        if (i > 0) {
            arrowEntity.m_36767_((byte)i);
        }
        return arrowEntity;
    }

    public static void fireProjectiles(Level world, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, float p_220014_4_, float p_220014_5_) {
        List<ItemStack> list = GearCrossbowItem.m_40941_(crossbow);
        float[] afloat = GearCrossbowItem.m_220023_(shooter.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean flag;
            ItemStack itemstack = list.get(i);
            boolean bl = flag = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            if (itemstack.m_41619_()) continue;
            if (i == 0) {
                GearCrossbowItem.m_40894_(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 0.0f);
                continue;
            }
            if (i == 1) {
                GearCrossbowItem.m_40894_(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, -10.0f);
                continue;
            }
            if (i != 2) continue;
            GearCrossbowItem.m_40894_(world, shooter, hand, crossbow, itemstack, afloat[i], flag, p_220014_4_, p_220014_5_, 10.0f);
        }
        GearCrossbowItem.m_40905_(world, shooter, crossbow);
    }

    private static float[] m_220023_(RandomSource random) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, GearCrossbowItem.getRandomShotPitch(random, flag), GearCrossbowItem.getRandomShotPitch(random, !flag)};
    }

    private static float getRandomShotPitch(RandomSource random, boolean p_220032_0_) {
        float f = p_220032_0_ ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void m_40905_(Level p_220015_0_, LivingEntity p_220015_1_, ItemStack p_220015_2_) {
        if (p_220015_1_ instanceof ServerPlayer) {
            ServerPlayer serverplayerentity = (ServerPlayer)p_220015_1_;
            if (!p_220015_0_.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverplayerentity, p_220015_2_);
            }
            serverplayerentity.m_36246_(Stats.f_12982_.m_12902_((Object)p_220015_2_.m_41720_()));
        }
        GearCrossbowItem.clearProjectiles(p_220015_2_);
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        if (!worldIn.f_46443_) {
            int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent soundevent = this.m_40851_(i);
            SoundEvent soundevent1 = i == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(stack.m_41779_() - count) / (float)GearCrossbowItem.getChargeTime(stack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                worldIn.m_6263_(null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), soundevent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundevent1 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                worldIn.m_6263_(null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), soundevent1, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public static int getChargeTime(ItemStack stack) {
        float baseTime = 25.0f / GearData.getStat(stack, ItemStats.RANGED_SPEED);
        int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return Math.round(Mth.m_14036_((float)(baseTime - (float)(5 * quickCharge)), (float)5.0f, (float)50.0f));
    }

    private static float m_40945_(ItemStack stack) {
        return stack.m_41720_() instanceof GearCrossbowItem && GearCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, false);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        GearHelper.setDamage(stack, damage, (x$0, x$1) -> super.setDamage(x$0, x$1));
    }

    public int getMaxDamage(ItemStack stack) {
        return GearData.getStatInt(stack, ItemStats.DURABILITY);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public Rarity m_41460_(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public int getAnimationFrames() {
        return 4;
    }

    @Override
    public int getAnimationFrame(ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity) {
        ItemPropertyFunction pullProperty;
        float pulling;
        ItemPropertyFunction chargedProperty = ModelPropertiesHelper.get(stack, new ResourceLocation("charged"));
        if (chargedProperty != null && chargedProperty.m_141951_(stack, world, entity, 0) > 0.0f) {
            return 3;
        }
        ItemPropertyFunction pullingProperty = ModelPropertiesHelper.get(stack, new ResourceLocation("pulling"));
        if (pullingProperty != null && (pulling = pullingProperty.m_141951_(stack, world, entity, 0)) > 0.0f && (pullProperty = ModelPropertiesHelper.get(stack, new ResourceLocation("pull"))) != null) {
            float pull = pullProperty.m_141951_(stack, world, entity, 0);
            if (pull > 1.0f) {
                return 3;
            }
            if (pull > 0.58f) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

