/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.ritual.CraftingRitual;
import elucent.eidolon.common.tile.BrazierTileEntity;
import elucent.eidolon.recipe.RitualRecipe;
import elucent.eidolon.registries.EidolonRecipes;
import elucent.eidolon.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class ItemRitualRecipe
extends RitualRecipe {
    public ItemStack result;
    public boolean keepNbtOfReagent = false;
    public ResourceLocation symbol;
    public int color;

    public ItemRitualRecipe(ResourceLocation recipeId, List<Ingredient> stacks, List<Ingredient> foci, Ingredient reagent, ItemStack output, boolean keepNbtOfReagent, float healthRequirement) {
        super(recipeId, reagent, stacks, foci, healthRequirement);
        this.result = output;
        this.keepNbtOfReagent = keepNbtOfReagent;
    }

    @Override
    @NotNull
    public ItemStack assemble(@NotNull BrazierTileEntity inv, @NotNull RegistryAccess registryAccess) {
        ItemStack result = this.result.m_41777_();
        if (this.keepNbtOfReagent && inv.getStack().m_41782_()) {
            result.m_41751_(inv.getStack().m_41783_());
            result.m_41721_(0);
        }
        return result.m_41777_();
    }

    @Override
    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.result == null ? ItemStack.f_41583_ : this.result.m_41777_();
    }

    @Override
    public Ritual getRitual() {
        if (this.symbol != null && this.color != 0) {
            return new CraftingRitual(this.symbol, this.color, this.result, this.keepNbtOfReagent).setRegistryName(this.id);
        }
        return new CraftingRitual.SanguineRitual(this.result).setRegistryName(this.id);
    }

    @Override
    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "eidolon:ritual_brazier_crafting");
        ItemRitualRecipe.addRitualElements(this, jsonobject);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", RegistryUtil.getRegistryName(this.result.m_41720_()).toString());
        int count = this.result.m_41613_();
        if (count > 1) {
            resultObj.addProperty("count", (Number)count);
        }
        jsonobject.add("output", (JsonElement)resultObj);
        jsonobject.addProperty("keepNbtOfReagent", Boolean.valueOf(this.keepNbtOfReagent));
        return jsonobject;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EidolonRecipes.CRAFTING_RITUAL_RECIPE.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)EidolonRecipes.CRAFTING_RITUAL_TYPE.get();
    }

    public static class SerializerCrafting
    extends RitualRecipe.Serializer<ItemRitualRecipe> {
        @NotNull
        public ItemRitualRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            float healthRequirement = json.has("healthRequirement") ? GsonHelper.m_13915_((JsonObject)json, (String)"healthRequirement") : 0.0f;
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            boolean keepNbtOfReagent = json.has("keepNbtOfReagent") && GsonHelper.m_13912_((JsonObject)json, (String)"keepNbtOfReagent");
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            List<Ingredient> stacks = RitualRecipe.getPedestalItems(pedestalItems);
            JsonArray focusItems = GsonHelper.m_13933_((JsonObject)json, (String)"focusItems");
            List<Ingredient> foci = RitualRecipe.getPedestalItems(focusItems);
            return new ItemRitualRecipe(recipeId, stacks, foci, reagent, output, keepNbtOfReagent, healthRequirement);
        }

        @Nullable
        public ItemRitualRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            int length2 = buffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            ArrayList<Ingredient> foci = new ArrayList<Ingredient>();
            for (int i = 0; i < length2; ++i) {
                try {
                    foci.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            float healthRequirement = buffer.readFloat();
            ItemStack output = buffer.m_130267_();
            boolean keepNbtOfReagent = buffer.readBoolean();
            return new ItemRitualRecipe(recipeId, stacks, foci, reagent, output, keepNbtOfReagent, healthRequirement);
        }

        @Override
        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull ItemRitualRecipe recipe) {
            super.toNetwork(buf, recipe);
            buf.m_130055_(recipe.result);
            buf.writeBoolean(recipe.keepNbtOfReagent);
        }
    }
}

