/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.spell;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.common.spell.StaticSpell;
import elucent.eidolon.util.EidolonFakePlayer;
import java.util.List;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExecCommandSpell
extends StaticSpell {
    private final List<String> commands;

    public ExecCommandSpell(ResourceLocation id, int manaCost, Sign[] signs, List<String> commands) {
        super(id, manaCost, signs);
        this.commands = commands;
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        return true;
    }

    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            MinecraftServer server = world.m_7654_();
            for (String command : this.commands) {
                if (!server.m_6993_() || StringUtil.m_14408_((String)command)) continue;
                try {
                    if (player == null) {
                        EidolonFakePlayer fakePlayer = EidolonFakePlayer.getPlayer(serverWorld);
                        fakePlayer.m_146884_(pos.m_252807_());
                        player = fakePlayer;
                    }
                    CommandSourceStack commandSource = player.m_20203_().m_81325_(2).m_81324_();
                    server.m_129892_().m_230957_(commandSource, command);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Executing command ritual");
                    CrashReportCategory crashreportcategory = crashreport.m_127514_("Command to be executed");
                    crashreportcategory.m_128159_("Command", (Object)command);
                    throw new ReportedException(crashreport);
                }
            }
        }
    }
}

