/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import elucent.eidolon.common.entity.SpellProjectileEntity;
import elucent.eidolon.common.item.curio.EidolonCurio;
import elucent.eidolon.registries.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class VoidAmuletItem
extends EidolonCurio {
    public VoidAmuletItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(VoidAmuletItem::onDamage);
    }

    static int getCooldown(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("cooldown")) {
            return tag.m_128451_("cooldown");
        }
        return 0;
    }

    static void setCooldown(ItemStack stack, int cooldown) {
        stack.m_41784_().m_128405_("cooldown", cooldown);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (!slotContext.entity().f_19853_.f_46443_ && VoidAmuletItem.getCooldown(stack) > 0) {
            VoidAmuletItem.setCooldown(stack, VoidAmuletItem.getCooldown(stack) - 1);
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)Registry.VOID_AMULET.get()).ifPresent(stack -> {
                if (VoidAmuletItem.getCooldown(stack.stack()) == 0 && (event.getSource().m_7640_() instanceof Projectile || event.getSource().m_7640_() instanceof SpellProjectileEntity)) {
                    event.setCanceled(true);
                    if (!event.getEntity().m_20193_().f_46443_) {
                        event.getEntity().m_20193_().m_5594_(null, event.getEntity().m_20183_(), SoundEvents.f_12557_, SoundSource.PLAYERS, 1.0f, 0.75f);
                    }
                    VoidAmuletItem.setCooldown(stack.stack(), 100);
                }
            });
        }
    }
}

