/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.item.curio;

import com.google.common.collect.Multimap;
import elucent.eidolon.common.item.curio.BasicBeltItem;
import elucent.eidolon.registries.Registry;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class GravityBeltItem
extends BasicBeltItem {
    final UUID ATTR_ID = new UUID(6937061617091731127L, 7120126291930051139L);

    public GravityBeltItem(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(GravityBeltItem::onFall);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        if (CuriosApi.getCuriosHelper().findFirstCurio(event.getEntity(), (Item)Registry.GRAVITY_BELT.get()).isPresent()) {
            event.setDistance(event.getDistance() / 4.0f);
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = super.getAttributeModifiers(slotContext, uuid, stack);
        map.put((Object)((Attribute)ForgeMod.ENTITY_GRAVITY.get()), (Object)new AttributeModifier(this.ATTR_ID, "eidolon:gravity_belt", (double)-0.6f, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return map;
    }
}

